/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql;

import java.util.function.Supplier;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class ExceptionUtils {
    public static VerificationException math(Source source, ArithmeticException e) {
        return new VerificationException("arithmetic exception in expression [{}]: [{}]", source.text(), e.getMessage());
    }

    public static void assertIllegalState(Boolean condition, String message) {
        if (Assertions.ENABLED && !condition.booleanValue()) {
            throw new IllegalStateException(message);
        }
    }

    public static void assertIllegalState(Supplier<Boolean> condition, String message) {
        if (Assertions.ENABLED && !condition.get().booleanValue()) {
            throw new IllegalStateException(message);
        }
    }
}

