/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.tasks;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.RemovedTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.test.tasks.MockTaskManagerListener;
import org.elasticsearch.threadpool.ThreadPool;
import org.mockito.Mockito;

public class MockTaskManager
extends TaskManager {
    private static final Logger logger = LogManager.getLogger(MockTaskManager.class);
    public static final Setting<Boolean> USE_MOCK_TASK_MANAGER_SETTING = Setting.boolSetting((String)"tests.mock.taskmanager.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SPY_TASK_MANAGER_SETTING = Setting.boolSetting((String)"tests.spy.taskmanager.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Collection<MockTaskManagerListener> listeners = new CopyOnWriteArrayList<MockTaskManagerListener>();

    public MockTaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        super(settings, threadPool, taskHeaders, Tracer.NOOP);
    }

    public static TaskManager create(Settings settings, ThreadPool threadPool, Set<String> taskHeaders, Tracer tracer, String nodeId) {
        MockTaskManager taskManager = (Boolean)USE_MOCK_TASK_MANAGER_SETTING.get(settings) != false ? new MockTaskManager(settings, threadPool, taskHeaders) : new TaskManager(settings, threadPool, taskHeaders, tracer, nodeId);
        return (Boolean)SPY_TASK_MANAGER_SETTING.get(settings) != false ? (TaskManager)Mockito.spy((Object)((Object)taskManager)) : taskManager;
    }

    public Task register(String type, String action, TaskAwareRequest request) {
        Task task = super.register(type, action, request);
        for (MockTaskManagerListener listener : this.listeners) {
            try {
                listener.onTaskRegistered(task);
            }
            catch (Exception e) {
                logger.warn(() -> Strings.format((String)"failed to notify task manager listener about registering the task with id %s", (Object[])new Object[]{task.getId()}), (Throwable)e);
            }
        }
        return task;
    }

    public Task unregister(Task task) {
        Task removedTask = super.unregister(task);
        if (removedTask != null) {
            for (MockTaskManagerListener listener : this.listeners) {
                try {
                    listener.onTaskUnregistered(task);
                }
                catch (Exception e) {
                    logger.warn(() -> Strings.format((String)"failed to notify task manager listener about unregistering the task with id %s", (Object[])new Object[]{task.getId()}), (Throwable)e);
                }
            }
        } else {
            logger.warn("trying to remove the same with id {} twice", (Object)task.getId());
        }
        return removedTask;
    }

    public void addListener(MockTaskManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MockTaskManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void registerRemovedTaskListener(RemovedTaskListener removedTaskListener) {
        super.registerRemovedTaskListener(removedTaskListener);
        for (MockTaskManagerListener listener : this.listeners) {
            try {
                listener.onRemovedTaskListenerRegistered(removedTaskListener);
            }
            catch (Exception e) {
                logger.warn("failed to notify task manager listener about a registered removed task listener", (Throwable)e);
            }
        }
    }
}

