/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractWireTestCase<T>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    protected abstract T createTestInstance();

    protected abstract T mutateInstance(T var1) throws IOException;

    public final void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            T testInstance = this.createTestInstance();
            try {
                EqualsHashCodeTestUtils.checkEqualsAndHashCode(testInstance, this::copyInstance, this::mutateInstance, this::dispose);
                continue;
            }
            finally {
                this.dispose(testInstance);
            }
        }
    }

    protected void dispose(T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testConcurrentEquals() throws IOException, InterruptedException, ExecutionException {
        Object testInstance = this.createTestInstance();
        try {
            Object copy = this.copyInstance(testInstance);
            try {
                int rounds = AbstractWireTestCase.scaledRandomIntBetween(300, 5000);
                this.concurrentTest(() -> {
                    for (int r = 0; r < rounds; ++r) {
                        AbstractWireTestCase.assertEquals((Object)testInstance, (Object)copy);
                    }
                });
            }
            finally {
                this.dispose(copy);
            }
        }
        finally {
            this.dispose(testInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentTest(Runnable r) throws InterruptedException, ExecutionException {
        int threads = 5;
        int tasks = threads * 2;
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        try {
            ArrayList results = new ArrayList();
            for (int t = 0; t < tasks; ++t) {
                results.add(exec.submit(r));
            }
            for (Future future : results) {
                future.get();
            }
        }
        finally {
            exec.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testConcurrentHashCode() throws InterruptedException, ExecutionException {
        Object testInstance = this.createTestInstance();
        try {
            int firstHashCode = testInstance.hashCode();
            int rounds = AbstractWireTestCase.scaledRandomIntBetween(300, 5000);
            this.concurrentTest(() -> {
                for (int r = 0; r < rounds; ++r) {
                    AbstractWireTestCase.assertEquals((long)firstHashCode, (long)testInstance.hashCode());
                }
            });
        }
        finally {
            this.dispose(testInstance);
        }
    }

    public void testToString() throws Exception {
        T testInstance = this.createTestInstance();
        try {
            String toString = testInstance.toString();
            AbstractWireTestCase.assertNotNull((Object)toString);
            AbstractWireTestCase.assertThat(toString, Matchers.not((Matcher)Matchers.emptyString()));
        }
        finally {
            this.dispose(testInstance);
        }
    }

    public final void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            T testInstance = this.createTestInstance();
            try {
                this.assertSerialization(testInstance);
                continue;
            }
            finally {
                this.dispose(testInstance);
            }
        }
    }

    public final void testConcurrentSerialization() throws InterruptedException, ExecutionException {
        T testInstance = this.createTestInstance();
        try {
            int rounds = AbstractWireTestCase.scaledRandomIntBetween(300, 2000);
            this.concurrentTest(() -> {
                try {
                    for (int r = 0; r < rounds; ++r) {
                        this.assertSerialization(testInstance);
                    }
                }
                catch (IOException | AssertionError e) {
                    throw new AssertionError("error serializing [" + String.valueOf(testInstance) + "]", (Throwable)e);
                }
            });
        }
        finally {
            this.dispose(testInstance);
        }
    }

    protected final void assertSerialization(T testInstance) throws IOException {
        this.assertSerialization(testInstance, TransportVersion.current());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertSerialization(T testInstance, TransportVersion version) throws IOException {
        T deserializedInstance = this.copyInstance(testInstance, version);
        try {
            this.assertEqualInstances(testInstance, deserializedInstance);
        }
        finally {
            this.dispose(deserializedInstance);
        }
    }

    protected void assertEqualInstances(T expectedInstance, T newInstance) {
        if (this.shouldBeSame(newInstance)) {
            AbstractWireTestCase.assertSame(newInstance, expectedInstance);
        } else {
            AbstractWireTestCase.assertNotSame(newInstance, expectedInstance);
        }
        AbstractWireTestCase.assertThat(newInstance, Matchers.equalTo(expectedInstance));
        AbstractWireTestCase.assertThat(newInstance.hashCode(), Matchers.equalTo((Object)expectedInstance.hashCode()));
    }

    protected boolean shouldBeSame(T newInstance) {
        return false;
    }

    protected final T copyInstance(T instance) throws IOException {
        return this.copyInstance(instance, TransportVersion.current());
    }

    protected abstract T copyInstance(T var1, TransportVersion var2) throws IOException;

    protected NamedWriteableRegistry getNamedWriteableRegistry() {
        return new NamedWriteableRegistry(Collections.emptyList());
    }
}

