/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.tests.geo.GeoTestUtil;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.GeometryNormalizer;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.geo.BaseShapeQueryTestCase;
import org.elasticsearch.search.geo.DatelinePointShapeQueryTestCase;
import org.elasticsearch.search.geo.SpatialQueryBuilders;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public abstract class GeoShapeQueryTestCase
extends BaseShapeQueryTestCase<GeoShapeQueryBuilder> {
    private final SpatialQueryBuilders<GeoShapeQueryBuilder> geoShapeQueryBuilder = SpatialQueryBuilders.GEO;
    private final DatelinePointShapeQueryTestCase dateline = new DatelinePointShapeQueryTestCase();

    @Override
    protected SpatialQueryBuilders<GeoShapeQueryBuilder> queryBuilder() {
        return this.geoShapeQueryBuilder;
    }

    @Override
    protected String fieldTypeName() {
        return "geo_shape";
    }

    public void testRectangleSpanningDateline() throws Exception {
        this.dateline.testRectangleSpanningDateline(this);
    }

    public void testPolygonSpanningDateline() throws Exception {
        this.dateline.testPolygonSpanningDateline(this);
    }

    public void testMultiPolygonSpanningDateline() throws Exception {
        this.dateline.testMultiPolygonSpanningDateline(this);
    }

    public void testEnvelopeSpanningDateline() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        String doc1 = "{\n  \"geo\": {\n    \"coordinates\": [ -33.918711, 18.847685 ],\n    \"type\": \"Point\"\n  }\n}";
        this.client().index((IndexRequest)new IndexRequest("test").id("1").source(doc1, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        String doc2 = "{\n  \"geo\": {\n    \"coordinates\": [ -49, 18.847685 ],\n    \"type\": \"Point\"\n  }\n}";
        this.client().index((IndexRequest)new IndexRequest("test").id("2").source(doc2, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        String doc3 = "{\n  \"geo\": {\n    \"coordinates\": [ 49, 18.847685 ],\n    \"type\": \"Point\"\n  }\n}";
        this.client().index((IndexRequest)new IndexRequest("test").id("3").source(doc3, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        CheckedSupplier querySupplier = GeoShapeQueryTestCase.randomFrom(() -> (GeoShapeQueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)new Rectangle(-21.0, -39.0, 44.0, 9.0)).relation(ShapeRelation.WITHIN), () -> {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("geo").startObject("shape").field("type", "envelope").startArray("coordinates").startArray().value(-21).value(44).endArray().startArray().value(-39).value(9).endArray().endArray().endObject().field("relation", "within").endObject().endObject();
            try (XContentParser parser = this.createParser(builder);){
                parser.nextToken();
                GeoShapeQueryBuilder geoShapeQueryBuilder = GeoShapeQueryBuilder.fromXContent((XContentParser)parser);
                return geoShapeQueryBuilder;
            }
        }, () -> {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("geo").field("shape", "BBOX (-21, -39, 44, 9)").field("relation", "within").endObject().endObject();
            try (XContentParser parser = this.createParser(builder);){
                parser.nextToken();
                GeoShapeQueryBuilder geoShapeQueryBuilder = GeoShapeQueryBuilder.fromXContent((XContentParser)parser);
                return geoShapeQueryBuilder;
            }
        });
        ElasticsearchAssertions.assertResponse(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)querySupplier.get()), response -> {
            GeoShapeQueryTestCase.assertEquals((long)2L, (long)response.getHits().getTotalHits().value());
            GeoShapeQueryTestCase.assertNotEquals((Object)"1", (Object)response.getHits().getAt(0).getId());
            GeoShapeQueryTestCase.assertNotEquals((Object)"1", (Object)response.getHits().getAt(1).getId());
        });
    }

    public void testIndexRectangleSpanningDateLine() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        Rectangle envelope = new Rectangle(178.0, -178.0, 10.0, -10.0);
        XContentBuilder docSource = GeoJson.toXContent((Geometry)envelope, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Point filterShape = new Point(179.0, 0.0);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().intersectionQuery("geo", (Geometry)filterShape)), 1L);
    }

    @Override
    protected Line makeRandomLine() {
        return GeoShapeQueryTestCase.randomValueOtherThanMany(l -> GeometryNormalizer.needsNormalize((Orientation)Orientation.CCW, (Geometry)l), () -> GeometryTestUtils.randomLine(false));
    }

    @Override
    protected org.elasticsearch.geometry.Polygon makeRandomPolygon() {
        return GeoShapeQueryTestCase.randomValueOtherThanMany(p -> GeometryNormalizer.needsNormalize((Orientation)Orientation.CCW, (Geometry)p), () -> GeometryTestUtils.randomPolygon(false));
    }

    @Override
    protected GeometryCollection<Geometry> makeRandomGeometryCollection() {
        return GeometryTestUtils.randomGeometryCollection(false);
    }

    @Override
    protected GeometryCollection<Geometry> makeRandomGeometryCollectionWithoutCircle(Geometry ... extra) {
        GeometryCollection<Geometry> randomCollection = GeometryTestUtils.randomGeometryCollectionWithoutCircle(false);
        if (extra.length == 0) {
            return randomCollection;
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Geometry geometry : randomCollection) {
            geometries.add(geometry);
        }
        Collections.addAll(geometries, extra);
        return new GeometryCollection(geometries);
    }

    @Override
    protected Point nextPoint() {
        return GeometryTestUtils.randomPoint(false);
    }

    @Override
    protected org.elasticsearch.geometry.Polygon nextPolygon() {
        Polygon randomPoly = GeoTestUtil.nextPolygon();
        return new org.elasticsearch.geometry.Polygon(new LinearRing(randomPoly.getPolyLons(), randomPoly.getPolyLats()));
    }

    @Override
    protected org.elasticsearch.geometry.Polygon nextPolygon2() {
        return GeometryTestUtils.randomPolygon(false);
    }
}

