/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopFloatLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopFloatLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopFloatLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopFloatLongAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopFloatLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopFloatLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopFloatLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopFloatLongAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopFloatLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopFloatLongGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_float of longs";
    }
}

