/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.DriverContext;

class SimpleLinearRegressionWithTimeseries
implements AggregatorState {
    long count = 0L;
    double sumVal = 0.0;
    long sumTs = 0L;
    double sumTsVal = 0.0;
    long sumTsSq = 0L;

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset + 0] = driverContext.blockFactory().newConstantLongBlockWith(this.count, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantDoubleBlockWith(this.sumVal, 1);
        blocks[offset + 2] = driverContext.blockFactory().newConstantLongBlockWith(this.sumTs, 1);
        blocks[offset + 3] = driverContext.blockFactory().newConstantDoubleBlockWith(this.sumTsVal, 1);
        blocks[offset + 4] = driverContext.blockFactory().newConstantLongBlockWith(this.sumTsSq, 1);
    }

    public void close() {
    }

    SimpleLinearRegressionWithTimeseries() {
    }

    void add(long ts, double val) {
        ++this.count;
        this.sumVal += val;
        this.sumTs += ts;
        this.sumTsVal += (double)ts * val;
        this.sumTsSq += ts * ts;
    }

    double slope() {
        if (this.count <= 1L) {
            return Double.NaN;
        }
        double numerator = (double)this.count * this.sumTsVal - (double)this.sumTs * this.sumVal;
        double denominator = this.count * this.sumTsSq - this.sumTs * this.sumTs;
        if (denominator == 0.0) {
            return Double.NaN;
        }
        return numerator / denominator * 1000.0;
    }

    double intercept() {
        if (this.count == 0L) {
            return 0.0;
        }
        double slp = this.slope();
        if (Double.isNaN(slp)) {
            return Double.NaN;
        }
        return (this.sumVal - slp * (double)this.sumTs) / (double)this.count;
    }
}

