/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AllLastLongByTimestampAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class AllLastLongByTimestampGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.LONG), new IntermediateStateDesc("hasValues", ElementType.BOOLEAN));
    private final AllLastLongByTimestampAggregator.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public AllLastLongByTimestampGroupingAggregatorFunction(List<Integer> channels, AllLastLongByTimestampAggregator.GroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static AllLastLongByTimestampGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new AllLastLongByTimestampGroupingAggregatorFunction(channels, AllLastLongByTimestampAggregator.initGrouping(driverContext), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock valueBlock = (LongBlock)page.getBlock(this.channels.get(0));
        final LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock, timestampBlock);
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                AllLastLongByTimestampGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                AllLastLongByTimestampGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                AllLastLongByTimestampGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, LongBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                AllLastLongByTimestampAggregator.combine(this.state, groupId, valuesPosition, valueBlock, timestampBlock);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock values = (LongBlock)valuesUncast;
        Object hasValuesUncast = page.getBlock(this.channels.get(2));
        if (hasValuesUncast.areAllValuesNull()) {
            return;
        }
        BooleanBlock hasValues = (BooleanBlock)hasValuesUncast;
        assert (timestamps.getPositionCount() == values.getPositionCount() && timestamps.getPositionCount() == hasValues.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                AllLastLongByTimestampAggregator.combineIntermediate(this.state, groupId, timestamps, values, hasValues, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, LongBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                AllLastLongByTimestampAggregator.combine(this.state, groupId, valuesPosition, valueBlock, timestampBlock);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock values = (LongBlock)valuesUncast;
        Object hasValuesUncast = page.getBlock(this.channels.get(2));
        if (hasValuesUncast.areAllValuesNull()) {
            return;
        }
        BooleanBlock hasValues = (BooleanBlock)hasValuesUncast;
        assert (timestamps.getPositionCount() == values.getPositionCount() && timestamps.getPositionCount() == hasValues.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                AllLastLongByTimestampAggregator.combineIntermediate(this.state, groupId, timestamps, values, hasValues, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            AllLastLongByTimestampAggregator.combine(this.state, groupId, valuesPosition, valueBlock, timestampBlock);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock values = (LongBlock)valuesUncast;
        Object hasValuesUncast = page.getBlock(this.channels.get(2));
        if (hasValuesUncast.areAllValuesNull()) {
            return;
        }
        BooleanBlock hasValues = (BooleanBlock)hasValuesUncast;
        assert (timestamps.getPositionCount() == values.getPositionCount() && timestamps.getPositionCount() == hasValues.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            AllLastLongByTimestampAggregator.combineIntermediate(this.state, groupId, timestamps, values, hasValues, valuesPosition);
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, LongBlock valueBlock, LongBlock timestampBlock) {
        if (valueBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
        if (timestampBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = AllLastLongByTimestampAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

