/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis.wrappers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.LenientBooleans;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugin.settings.BooleanSetting;
import org.elasticsearch.plugin.settings.IntSetting;
import org.elasticsearch.plugin.settings.ListSetting;
import org.elasticsearch.plugin.settings.LongSetting;
import org.elasticsearch.plugin.settings.StringSetting;

public class SettingsInvocationHandler
implements InvocationHandler {
    private static Logger LOGGER = LogManager.getLogger(SettingsInvocationHandler.class);
    private Settings settings;
    private Environment environment;

    public SettingsInvocationHandler(Settings settings, Environment environment) {
        this.settings = settings;
        this.environment = environment;
    }

    public static <T> T create(Settings settings, Class<T> parameterType, Environment environment) {
        return (T)Proxy.newProxyInstance(parameterType.getClassLoader(), new Class[]{parameterType}, (InvocationHandler)new SettingsInvocationHandler(settings, environment));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        assert (method.getAnnotations().length == 1);
        Annotation annotation = method.getAnnotations()[0];
        if (annotation instanceof IntSetting) {
            IntSetting setting = (IntSetting)annotation;
            return this.getValue(Integer::valueOf, setting.path(), setting.defaultValue());
        }
        if (annotation instanceof LongSetting) {
            LongSetting setting = (LongSetting)annotation;
            return this.getValue(Long::valueOf, setting.path(), setting.defaultValue());
        }
        if (annotation instanceof BooleanSetting) {
            BooleanSetting setting = (BooleanSetting)annotation;
            return this.getValue(v -> LenientBooleans.parseAndCheckForDeprecatedUsage(v, LenientBooleans.UsageCategory.SETTING, setting.path(), DeprecationCategory.SETTINGS), setting.path(), setting.defaultValue());
        }
        if (annotation instanceof StringSetting) {
            StringSetting setting = (StringSetting)annotation;
            return this.getValue(String::valueOf, setting.path(), setting.defaultValue());
        }
        if (annotation instanceof ListSetting) {
            ListSetting setting = (ListSetting)annotation;
            return this.settings.getAsList(setting.path(), Collections.emptyList());
        }
        throw new IllegalArgumentException("Unrecognised annotation " + String.valueOf(annotation));
    }

    private <T> T getValue(Function<String, T> parser, String path, T defaultValue) {
        String key = path;
        if (this.settings.get(key) != null) {
            return parser.apply(this.settings.get(key));
        }
        return defaultValue;
    }
}

