/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues.fn;

import java.io.IOException;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractBytesRefsFromOrdsBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class MvMinBytesRefsFromOrdsBlockLoader
extends AbstractBytesRefsFromOrdsBlockLoader {
    private final String fieldName;

    public MvMinBytesRefsFromOrdsBlockLoader(String fieldName) {
        super(fieldName);
        this.fieldName = fieldName;
    }

    @Override
    protected BlockLoader.AllReader singletonReader(SortedDocValues docValues) {
        return new AbstractBytesRefsFromOrdsBlockLoader.Singleton(docValues);
    }

    @Override
    protected BlockLoader.AllReader sortedSetReader(SortedSetDocValues docValues) {
        return new MvMinSortedSet(docValues);
    }

    public String toString() {
        return "MvMinBytesRefsFromOrds[" + this.fieldName + "]";
    }

    private static class MvMinSortedSet
    extends BlockDocValuesReader {
        private final SortedSetDocValues ordinals;

        MvMinSortedSet(SortedSetDocValues ordinals) {
            this.ordinals = ordinals;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            if (docs.count() - offset == 1) {
                return this.readSingleDoc(factory, docs.get(offset));
            }
            try (BlockLoader.SortedSetOrdinalsBuilder builder = factory.sortedSetOrdinalsBuilder(this.ordinals, docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.ordinals.docID()) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (!this.ordinals.advanceExact(doc)) {
                        builder.appendNull();
                        continue;
                    }
                    builder.appendOrd(Math.toIntExact(this.ordinals.nextOrd()));
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        private BlockLoader.Block readSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                return factory.constantNulls(1);
            }
            BytesRef v = this.ordinals.lookupOrd(this.ordinals.nextOrd());
            return factory.constantBytes(BytesRef.deepCopyOf((BytesRef)v), 1);
        }

        private void read(int docId, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                builder.appendNull();
                return;
            }
            builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "MvMinBytesRefsFromOrds.SortedSet";
        }
    }
}

