/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetResult
implements Writeable,
Iterable<DocumentField>,
ToXContentObject {
    public static final String _INDEX = "_index";
    public static final String _ID = "_id";
    static final String _VERSION = "_version";
    static final String _SEQ_NO = "_seq_no";
    static final String _PRIMARY_TERM = "_primary_term";
    static final String FOUND = "found";
    static final String FIELDS = "fields";
    private final String index;
    private final String id;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;
    private final boolean exists;
    private final Map<String, DocumentField> documentFields;
    private final Map<String, DocumentField> metaFields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;

    public GetResult(StreamInput in) throws IOException {
        this.index = in.readString();
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            in.readOptionalString();
        }
        this.id = in.readString();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            this.documentFields = DocumentField.readFieldsFromMapValues(in);
            this.metaFields = DocumentField.readFieldsFromMapValues(in);
        } else {
            this.metaFields = Collections.emptyMap();
            this.documentFields = Collections.emptyMap();
        }
    }

    public GetResult(String index, String id, long seqNo, long primaryTerm, long version, boolean exists, BytesReference source, Map<String, DocumentField> documentFields, Map<String, DocumentField> metaFields) {
        this.index = index;
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        assert (seqNo == -2L && primaryTerm == 0L || seqNo >= 0L && primaryTerm >= 1L) : "seqNo: " + seqNo + " primaryTerm: " + primaryTerm;
        assert (exists || seqNo == -2L && primaryTerm == 0L) : "doc not found but seqNo/primaryTerm are set";
        this.version = version;
        this.exists = exists;
        this.source = source;
        this.documentFields = documentFields == null ? Collections.emptyMap() : documentFields;
        this.metaFields = metaFields == null ? Collections.emptyMap() : metaFields;
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public BytesReference sourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = Source.fromBytes(this.source).source();
        return this.sourceAsMap;
    }

    public Map<String, DocumentField> getMetadataFields() {
        return this.metaFields;
    }

    public Map<String, DocumentField> getDocumentFields() {
        return this.documentFields;
    }

    public Map<String, DocumentField> getFields() {
        HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
        fields.putAll(this.metaFields);
        fields.putAll(this.documentFields);
        return fields;
    }

    public DocumentField field(String name) {
        return this.getFields().get(name);
    }

    @Override
    public Iterator<DocumentField> iterator() {
        Map<String, DocumentField> allFields = this.getFields();
        return allFields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.seqNo != -2L) {
            builder.field(_SEQ_NO, this.seqNo);
            builder.field(_PRIMARY_TERM, this.primaryTerm);
        }
        for (DocumentField field : this.metaFields.values()) {
            if (field.getName().equals("_ignored") || field.getName().equals("_ignored_source")) {
                builder.field(field.getName(), field.getValues());
                continue;
            }
            builder.field(field.getName(), field.getValue());
        }
        builder.field(FOUND, this.exists);
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!this.documentFields.isEmpty()) {
            builder.startObject(FIELDS);
            for (DocumentField field : this.documentFields.values()) {
                field.getValidValuesWriter().toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX, this.index);
        builder.field(_ID, this.id);
        if (this.isExists()) {
            if (this.version != -1L) {
                builder.field(_VERSION, this.version);
            }
            this.toXContentEmbedded(builder, params);
        } else {
            builder.field(FOUND, false);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalString("_doc");
        }
        out.writeString(this.id);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            out.writeMapValues(this.documentFields);
            out.writeMapValues(this.metaFields);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResult getResult = (GetResult)o;
        return this.version == getResult.version && this.seqNo == getResult.seqNo && this.primaryTerm == getResult.primaryTerm && this.exists == getResult.exists && Objects.equals(this.index, getResult.index) && Objects.equals(this.id, getResult.id) && Objects.equals(this.documentFields, getResult.documentFields) && Objects.equals(this.metaFields, getResult.metaFields) && Objects.equals(this.sourceAsMap(), getResult.sourceAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.seqNo, this.primaryTerm, this.exists, this.index, this.id, this.documentFields, this.metaFields, this.sourceAsMap());
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

