/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public class ES813FlatVectorFormat
extends KnnVectorsFormat {
    static final String NAME = "ES813FlatVectorFormat";
    private static final FlatVectorsFormat format = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());

    public ES813FlatVectorFormat() {
        super(NAME);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES813FlatVectorWriter(format.fieldsWriter(state));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES813FlatVectorReader(format.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    static class ES813FlatVectorWriter
    extends KnnVectorsWriter {
        private final FlatVectorsWriter writer;

        ES813FlatVectorWriter(FlatVectorsWriter writer) {
            this.writer = writer;
        }

        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            return this.writer.addField(fieldInfo);
        }

        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            this.writer.flush(maxDoc, sortMap);
        }

        public void finish() throws IOException {
            this.writer.finish();
        }

        public void close() throws IOException {
            this.writer.close();
        }

        public long ramBytesUsed() {
            return this.writer.ramBytesUsed();
        }

        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            this.writer.mergeOneField(fieldInfo, mergeState);
        }
    }

    static class ES813FlatVectorReader
    extends KnnVectorsReader {
        private final FlatVectorsReader reader;

        ES813FlatVectorReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            this.collectAllMatchingDocs(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        private void collectAllMatchingDocs(KnnCollector knnCollector, AcceptDocs acceptDocs, RandomVectorScorer scorer) throws IOException {
            OrdinalTranslatedKnnCollector collector = new OrdinalTranslatedKnnCollector(knnCollector, arg_0 -> ((RandomVectorScorer)scorer).ordToDoc(arg_0));
            Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs.bits());
            for (int i = 0; i < scorer.maxOrd(); ++i) {
                if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
                collector.collect(i, scorer.score(i));
                collector.incVisitedCount(1);
            }
            assert (!collector.earlyTerminated());
        }

        public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            this.collectAllMatchingDocs(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return this.reader.getOffHeapByteSize(fieldInfo);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

