/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.util.LenientBooleans;
import org.elasticsearch.index.codec.tsdb.BinaryDVCompressionMode;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesConsumer;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesProducer;

public class ES819TSDBDocValuesFormat
extends DocValuesFormat {
    static final int NUMERIC_BLOCK_SHIFT = 7;
    static final int NUMERIC_LARGE_BLOCK_SHIFT = 9;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    static final String CODEC_NAME = "ES819TSDB";
    static final String DATA_CODEC = "ES819TSDBDocValuesData";
    static final String DATA_EXTENSION = "dvd";
    static final String META_CODEC = "ES819TSDBDocValuesMetadata";
    static final String META_EXTENSION = "dvm";
    static final byte NUMERIC = 0;
    static final byte BINARY = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_NUMERIC = 4;
    static final int VERSION_START = 0;
    static final int VERSION_BINARY_DV_COMPRESSION = 1;
    static final int VERSION_NUMERIC_LARGE_BLOCKS = 2;
    static final int VERSION_CURRENT = 2;
    static final int TERMS_DICT_BLOCK_LZ4_SHIFT = 6;
    static final int TERMS_DICT_BLOCK_LZ4_SIZE = 64;
    static final int TERMS_DICT_BLOCK_LZ4_MASK = 63;
    static final int TERMS_DICT_REVERSE_INDEX_SHIFT = 10;
    static final int TERMS_DICT_REVERSE_INDEX_SIZE = 1024;
    static final int TERMS_DICT_REVERSE_INDEX_MASK = 1023;
    public static final int BLOCK_BYTES_THRESHOLD = 131072;
    public static final int BLOCK_COUNT_THRESHOLD = 1024;
    private static final int DEFAULT_SKIP_INDEX_INTERVAL_SIZE = 4096;
    private static final long SKIP_INDEX_INTERVAL_BYTES = 29L;
    static final int SKIP_INDEX_LEVEL_SHIFT = 3;
    static final int SKIP_INDEX_MAX_LEVEL = 4;
    static final long[] SKIP_INDEX_JUMP_LENGTH_PER_LEVEL = new long[4];
    static final boolean OPTIMIZED_MERGE_ENABLE_DEFAULT;
    static final String OPTIMIZED_MERGE_ENABLED_NAME;
    public static final int ORDINAL_RANGE_ENCODING_MIN_DOC_PER_ORDINAL = 512;
    public static final int ORDINAL_RANGE_ENCODING_BLOCK_SHIFT = 12;
    final int numericBlockShift;
    final int skipIndexIntervalSize;
    final int minDocsPerOrdinalForRangeEncoding;
    final boolean enableOptimizedMerge;
    final BinaryDVCompressionMode binaryDVCompressionMode;
    final boolean enablePerBlockCompression;

    private static boolean getOptimizedMergeEnabledDefault() {
        return LenientBooleans.parseAndCheckForDeprecatedUsage(System.getProperty(OPTIMIZED_MERGE_ENABLED_NAME, Boolean.TRUE.toString()), LenientBooleans.UsageCategory.SYSTEM_PROPERTY, OPTIMIZED_MERGE_ENABLED_NAME, DeprecationCategory.PARSING);
    }

    public ES819TSDBDocValuesFormat() {
        this(7);
    }

    public ES819TSDBDocValuesFormat(int numericBlockShift) {
        this(4096, 512, OPTIMIZED_MERGE_ENABLE_DEFAULT, BinaryDVCompressionMode.COMPRESSED_ZSTD_LEVEL_1, true);
    }

    public ES819TSDBDocValuesFormat(BinaryDVCompressionMode binaryDVCompressionMode) {
        this(4096, 512, OPTIMIZED_MERGE_ENABLE_DEFAULT, binaryDVCompressionMode, true, 7);
    }

    public ES819TSDBDocValuesFormat(BinaryDVCompressionMode binaryDVCompressionMode, boolean enablePerBlockCompression) {
        this(4096, 512, OPTIMIZED_MERGE_ENABLE_DEFAULT, binaryDVCompressionMode, enablePerBlockCompression, 7);
    }

    public ES819TSDBDocValuesFormat(int skipIndexIntervalSize, int minDocsPerOrdinalForRangeEncoding, boolean enableOptimizedMerge, BinaryDVCompressionMode binaryDVCompressionMode, boolean enablePerBlockCompression) {
        this(skipIndexIntervalSize, minDocsPerOrdinalForRangeEncoding, enableOptimizedMerge, binaryDVCompressionMode, enablePerBlockCompression, 7);
    }

    public ES819TSDBDocValuesFormat(int skipIndexIntervalSize, int minDocsPerOrdinalForRangeEncoding, boolean enableOptimizedMerge, BinaryDVCompressionMode binaryDVCompressionMode, boolean enablePerBlockCompression, int numericBlockShift) {
        super(CODEC_NAME);
        assert (numericBlockShift == 7 || numericBlockShift == 9) : numericBlockShift;
        if (skipIndexIntervalSize < 2) {
            throw new IllegalArgumentException("skipIndexIntervalSize must be > 1, got [" + skipIndexIntervalSize + "]");
        }
        this.skipIndexIntervalSize = skipIndexIntervalSize;
        this.minDocsPerOrdinalForRangeEncoding = minDocsPerOrdinalForRangeEncoding;
        this.enableOptimizedMerge = enableOptimizedMerge;
        this.binaryDVCompressionMode = binaryDVCompressionMode;
        this.enablePerBlockCompression = enablePerBlockCompression;
        this.numericBlockShift = numericBlockShift;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new ES819TSDBDocValuesConsumer(this.binaryDVCompressionMode, this.enablePerBlockCompression, state, this.skipIndexIntervalSize, this.minDocsPerOrdinalForRangeEncoding, this.enableOptimizedMerge, this.numericBlockShift, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new ES819TSDBDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    static {
        ES819TSDBDocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[0] = 24L;
        for (int level = 1; level < 4; ++level) {
            ES819TSDBDocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level - 1];
            int n = level;
            SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n] + (long)(1 << level * 3) * 29L;
            int n2 = level;
            SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n2] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n2] - (long)(1 << (level - 1) * 3);
        }
        OPTIMIZED_MERGE_ENABLED_NAME = ES819TSDBDocValuesConsumer.class.getName() + ".enableOptimizedMerge";
        OPTIMIZED_MERGE_ENABLE_DEFAULT = ES819TSDBDocValuesFormat.getOptimizedMergeEnabledDefault();
    }
}

