/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.bloomfilter;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MappedMultiFields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldDataInput;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.codec.bloomfilter.BloomFilterHashFunctions;

public class ES93BloomFilterStoredFieldsFormat
extends StoredFieldsFormat {
    public static final String STORED_FIELDS_BLOOM_FILTER_FORMAT_NAME = "ES93BloomFilterStoredFieldsFormat";
    public static final String STORED_FIELDS_BLOOM_FILTER_EXTENSION = "sfbf";
    public static final String STORED_FIELDS_METADATA_BLOOM_FILTER_EXTENSION = "sfbfm";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;
    private static final int[] PRIMES = new int[]{2, 5, 11, 17, 23, 29, 41, 47, 53, 59, 71};
    private static final int DEFAULT_NUM_HASH_FUNCTIONS = 7;
    private static final byte BLOOM_FILTER_STORED = 1;
    private static final byte BLOOM_FILTER_NOT_STORED = 0;
    private static final ByteSizeValue MAX_BLOOM_FILTER_SIZE = ByteSizeValue.ofMb(8L);
    private final BigArrays bigArrays;
    private final String segmentSuffix;
    private final StoredFieldsFormat delegate;
    private final String bloomFilterFieldName;
    private final int numHashFunctions;
    private final int bloomFilterSizeInBits;

    public ES93BloomFilterStoredFieldsFormat(BigArrays bigArrays, String segmentSuffix, StoredFieldsFormat delegate, ByteSizeValue bloomFilterSize, String bloomFilterFieldName) {
        this.bigArrays = bigArrays;
        this.segmentSuffix = segmentSuffix;
        this.delegate = delegate;
        this.bloomFilterFieldName = bloomFilterFieldName;
        this.numHashFunctions = 7;
        if (bloomFilterSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("bloom filter size must be greater than 0");
        }
        this.bloomFilterSizeInBits = ES93BloomFilterStoredFieldsFormat.closestPowerOfTwoBloomFilterSizeInBits(bloomFilterSize);
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new Reader(directory, si, fn, context, this.segmentSuffix, this.delegate.fieldsReader(directory, si, fn, context));
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        return new Writer(directory, si, context, this.segmentSuffix, this.bigArrays, this.numHashFunctions, this::getBloomFilterSizeInBits, this.bloomFilterFieldName, this.delegate.fieldsWriter(directory, si, context));
    }

    int getBloomFilterSizeInBits() {
        return this.bloomFilterSizeInBits;
    }

    static int closestPowerOfTwoBloomFilterSizeInBits(ByteSizeValue bloomFilterSize) {
        long closestPowerOfTwoBloomFilterSizeInBytes = Long.highestOneBit(bloomFilterSize.getBytes());
        if (closestPowerOfTwoBloomFilterSizeInBytes > MAX_BLOOM_FILTER_SIZE.getBytes()) {
            throw new IllegalArgumentException("bloom filter size [" + String.valueOf(bloomFilterSize) + "] is too large; must be " + String.valueOf(MAX_BLOOM_FILTER_SIZE) + " or less (rounded to nearest power of two)");
        }
        return Math.toIntExact(Math.multiplyExact(closestPowerOfTwoBloomFilterSizeInBytes, 8));
    }

    private static int[] hashTerm(BytesRef value, int[] outputs) {
        long hash64 = BloomFilterHashFunctions.MurmurHash3.hash64(value.bytes, value.offset, value.length);
        int upperHalf = (int)(hash64 >> 32);
        int lowerHalf = (int)hash64;
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = lowerHalf + PRIMES[i] * upperHalf & Integer.MAX_VALUE;
        }
        return outputs;
    }

    private static boolean isPowerOfTwo(int value) {
        return (value & value - 1) == 0;
    }

    private static String bloomFilterMetadataFileName(SegmentInfo segmentInfo, String segmentSuffix) {
        return IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)STORED_FIELDS_METADATA_BLOOM_FILTER_EXTENSION);
    }

    private static String bloomFilterFileName(SegmentInfo segmentInfo, String segmentSuffix) {
        return IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)STORED_FIELDS_BLOOM_FILTER_EXTENSION);
    }

    private static class Reader
    extends StoredFieldsReader
    implements BloomFilterProvider {
        @Nullable
        private final BloomFilterFieldReader bloomFilterFieldReader;
        private final StoredFieldsReader delegateReader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Reader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context, String segmentSuffix, StoredFieldsReader delegateReader) throws IOException {
            this.delegateReader = delegateReader;
            boolean success = false;
            try {
                this.bloomFilterFieldReader = BloomFilterFieldReader.open(directory, si, fn, context, segmentSuffix);
                success = true;
            }
            finally {
                if (!success) {
                    delegateReader.close();
                }
            }
        }

        public StoredFieldsReader clone() {
            return this;
        }

        public void checkIntegrity() throws IOException {
            if (this.bloomFilterFieldReader != null) {
                this.bloomFilterFieldReader.checkIntegrity();
            }
            this.delegateReader.checkIntegrity();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.bloomFilterFieldReader, this.delegateReader});
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            this.delegateReader.document(docID, visitor);
        }

        @Override
        public BloomFilter getBloomFilter() throws IOException {
            return this.bloomFilterFieldReader;
        }
    }

    static class Writer
    extends StoredFieldsWriter {
        private final Directory directory;
        private final SegmentInfo segmentInfo;
        private final IOContext context;
        private final String segmentSuffix;
        private final BigArrays bigArrays;
        private final IntSupplier defaultBloomFilterSizeInBitsSupplier;
        private final int numHashFunctions;
        private final String bloomFilterFieldName;
        private final StoredFieldsWriter delegateWriter;
        private final List<Closeable> toClose = new ArrayList<Closeable>();
        private final IndexOutput metadataOut;
        private BloomFilterWriter bloomFilterWriter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Writer(Directory directory, SegmentInfo segmentInfo, IOContext context, String segmentSuffix, BigArrays bigArrays, int numHashFunctions, IntSupplier defaultBloomFilterSizeInBitsSupplier, String bloomFilterFieldName, StoredFieldsWriter delegateWriter) throws IOException {
            this.directory = directory;
            this.segmentInfo = segmentInfo;
            this.context = context;
            this.segmentSuffix = segmentSuffix;
            this.bigArrays = bigArrays;
            this.defaultBloomFilterSizeInBitsSupplier = defaultBloomFilterSizeInBitsSupplier;
            assert (numHashFunctions <= PRIMES.length) : "Number of hash functions must be <= " + PRIMES.length + " but was " + numHashFunctions;
            this.numHashFunctions = numHashFunctions;
            this.bloomFilterFieldName = bloomFilterFieldName;
            this.delegateWriter = delegateWriter;
            this.toClose.add((Closeable)delegateWriter);
            boolean success = false;
            try {
                this.metadataOut = directory.createOutput(ES93BloomFilterStoredFieldsFormat.bloomFilterMetadataFileName(segmentInfo, segmentSuffix), context);
                this.toClose.add((Closeable)this.metadataOut);
                CodecUtil.writeIndexHeader((DataOutput)this.metadataOut, (String)ES93BloomFilterStoredFieldsFormat.STORED_FIELDS_BLOOM_FILTER_FORMAT_NAME, (int)0, (byte[])segmentInfo.getId(), (String)segmentSuffix);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toClose);
                }
            }
        }

        public void startDocument() throws IOException {
            this.delegateWriter.startDocument();
        }

        public void finishDocument() throws IOException {
            this.delegateWriter.finishDocument();
        }

        public void writeField(FieldInfo info, int value) throws IOException {
            if (!this.isBloomFilterField(info)) {
                this.delegateWriter.writeField(info, value);
            }
        }

        public void writeField(FieldInfo info, long value) throws IOException {
            if (!this.isBloomFilterField(info)) {
                this.delegateWriter.writeField(info, value);
            }
        }

        public void writeField(FieldInfo info, float value) throws IOException {
            if (!this.isBloomFilterField(info)) {
                this.delegateWriter.writeField(info, value);
            }
        }

        public void writeField(FieldInfo info, double value) throws IOException {
            if (!this.isBloomFilterField(info)) {
                this.delegateWriter.writeField(info, value);
            }
        }

        public void writeField(FieldInfo info, StoredFieldDataInput value) throws IOException {
            if (!this.isBloomFilterField(info)) {
                this.delegateWriter.writeField(info, value);
            }
        }

        public void writeField(FieldInfo info, String value) throws IOException {
            if (!this.isBloomFilterField(info)) {
                this.delegateWriter.writeField(info, value);
            }
        }

        public void writeField(FieldInfo info, BytesRef value) throws IOException {
            if (this.isBloomFilterField(info)) {
                this.addToBloomFilter(info, value);
            } else {
                this.delegateWriter.writeField(info, value);
            }
        }

        private boolean isBloomFilterField(FieldInfo info) {
            return this.bloomFilterWriter != null && this.bloomFilterWriter.fieldInfo.getFieldNumber() == info.getFieldNumber() || info.getName().equals(this.bloomFilterFieldName);
        }

        private int getBloomFilterSizeInBits() {
            int bloomFilterSizeInBits = this.defaultBloomFilterSizeInBitsSupplier.getAsInt();
            assert (ES93BloomFilterStoredFieldsFormat.isPowerOfTwo(bloomFilterSizeInBits)) : "Bloom filter size is not a power of 2: " + bloomFilterSizeInBits;
            return bloomFilterSizeInBits;
        }

        private void addToBloomFilter(FieldInfo info, BytesRef value) throws IOException {
            assert (info.getName().equals(this.bloomFilterFieldName)) : "Expected " + this.bloomFilterFieldName + " but got " + String.valueOf(info);
            this.maybeInitializeBloomFilterWriter(info, this.getBloomFilterSizeInBits());
            this.bloomFilterWriter.add(value);
        }

        public void finish(int numDocs) throws IOException {
            this.finishBloomFilterStoredFormat();
            this.delegateWriter.finish(numDocs);
        }

        private void finishBloomFilterStoredFormat() throws IOException {
            BloomFilterMetadata bloomFilterMetadata;
            BloomFilterMetadata bloomFilterMetadata2 = bloomFilterMetadata = this.bloomFilterWriter == null ? null : this.bloomFilterWriter.finish();
            if (bloomFilterMetadata != null) {
                this.metadataOut.writeByte((byte)1);
                bloomFilterMetadata.writeTo(this.metadataOut);
            } else {
                this.metadataOut.writeByte((byte)0);
            }
            CodecUtil.writeFooter((IndexOutput)this.metadataOut);
        }

        public int merge(MergeState mergeState) throws IOException {
            if (this.useOptimizedMerge(mergeState)) {
                this.mergeOptimized(mergeState);
            } else {
                this.rebuildBloomFilterFromSegments(mergeState);
            }
            this.finishBloomFilterStoredFormat();
            return this.delegateWriter.merge(mergeState);
        }

        private void mergeOptimized(MergeState mergeState) throws IOException {
            assert (this.useOptimizedMerge(mergeState));
            if (mergeState.storedFieldsReaders.length == 0) {
                return;
            }
            assert (mergeState.storedFieldsReaders[0] instanceof Reader);
            Reader firstReader = (Reader)mergeState.storedFieldsReaders[0];
            assert (firstReader.bloomFilterFieldReader != null);
            int mergedBloomFilterBitSetSizeInBits = firstReader.bloomFilterFieldReader.getBloomFilterBitSetSizeInBits();
            FieldInfo bloomFilterFieldInfo = mergeState.mergeFieldInfos.fieldInfo(this.bloomFilterFieldName);
            this.maybeInitializeBloomFilterWriter(bloomFilterFieldInfo, mergedBloomFilterBitSetSizeInBits);
            this.bloomFilterWriter.mergeBloomFiltersWithOr(mergeState);
        }

        private void rebuildBloomFilterFromSegments(MergeState mergeState) throws IOException {
            BytesRef term;
            ArrayList<FieldsProducer> fields = new ArrayList<FieldsProducer>();
            ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
            int docBase = 0;
            for (int readerIndex = 0; readerIndex < mergeState.fieldsProducers.length; ++readerIndex) {
                FieldsProducer f = mergeState.fieldsProducers[readerIndex];
                int maxDoc = mergeState.maxDocs[readerIndex];
                if (f != null) {
                    f.checkIntegrity();
                    slices.add(new ReaderSlice(docBase, maxDoc, readerIndex));
                    fields.add(f);
                }
                docBase += maxDoc;
            }
            MappedMultiFields mergedFields = new MappedMultiFields(mergeState, new MultiFields(fields.toArray(Fields.EMPTY_ARRAY), slices.toArray(ReaderSlice.EMPTY_ARRAY)));
            Terms terms = mergedFields.terms(this.bloomFilterFieldName);
            if (terms == null) {
                return;
            }
            FieldInfo bloomFilterFieldInfo = mergeState.mergeFieldInfos.fieldInfo(this.bloomFilterFieldName);
            assert (bloomFilterFieldInfo != null);
            this.maybeInitializeBloomFilterWriter(bloomFilterFieldInfo, this.getBloomFilterSizeInBits());
            TermsEnum termsEnum = terms.iterator();
            while ((term = termsEnum.next()) != null) {
                this.addToBloomFilter(bloomFilterFieldInfo, term);
            }
        }

        private boolean useOptimizedMerge(MergeState mergeState) {
            int expectedBloomFilterSize = -1;
            for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
                StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[i];
                if (!(storedFieldsReader instanceof Reader)) {
                    return false;
                }
                Reader reader = (Reader)storedFieldsReader;
                BloomFilterFieldReader bloomFilterFieldReader = reader.bloomFilterFieldReader;
                if (bloomFilterFieldReader == null) {
                    return false;
                }
                if (expectedBloomFilterSize == -1) {
                    expectedBloomFilterSize = bloomFilterFieldReader.bloomFilterBitSetSizeInBits;
                }
                if (bloomFilterFieldReader.bloomFilterBitSetSizeInBits == expectedBloomFilterSize) continue;
                return false;
            }
            return true;
        }

        public void close() throws IOException {
            IOUtils.close(this.toClose);
        }

        public long ramBytesUsed() {
            return this.bloomFilterWriter == null ? 0L : this.bloomFilterWriter.buffer.ramBytesUsed() + this.delegateWriter.ramBytesUsed();
        }

        private void maybeInitializeBloomFilterWriter(FieldInfo fieldInfo, int bitSetSizeInBits) throws IOException {
            assert (ES93BloomFilterStoredFieldsFormat.isPowerOfTwo(bitSetSizeInBits)) : "Expected a power of two but got " + bitSetSizeInBits;
            if (this.bloomFilterWriter != null) {
                return;
            }
            try {
                this.bloomFilterWriter = new BloomFilterWriter(fieldInfo, bitSetSizeInBits);
                this.toClose.add(this.bloomFilterWriter);
            }
            catch (IOException e) {
                IOUtils.closeWhileHandlingException(this.toClose);
                throw e;
            }
        }

        class BloomFilterWriter
        implements Closeable {
            private final FieldInfo fieldInfo;
            private final int bitsetSizeInBits;
            private final int bitSetSizeInBytes;
            private final ByteArray buffer;
            private final int[] hashes;
            private final IndexOutput bloomFilterDataOut;
            private boolean flushed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            BloomFilterWriter(FieldInfo fieldInfo, int bitsetSizeInBits) throws IOException {
                this.fieldInfo = fieldInfo;
                this.bitsetSizeInBits = bitsetSizeInBits;
                this.bitSetSizeInBytes = bitsetSizeInBits / 8;
                this.buffer = Writer.this.bigArrays.newByteArray(this.bitSetSizeInBytes, false);
                this.hashes = new int[Writer.this.numHashFunctions];
                this.bloomFilterDataOut = Writer.this.directory.createOutput(ES93BloomFilterStoredFieldsFormat.bloomFilterFileName(Writer.this.segmentInfo, Writer.this.segmentSuffix), Writer.this.context);
                boolean success = false;
                try {
                    CodecUtil.writeIndexHeader((DataOutput)this.bloomFilterDataOut, (String)ES93BloomFilterStoredFieldsFormat.STORED_FIELDS_BLOOM_FILTER_FORMAT_NAME, (int)0, (byte[])Writer.this.segmentInfo.getId(), (String)Writer.this.segmentSuffix);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.bloomFilterDataOut.close();
                    }
                }
            }

            private void add(BytesRef value) {
                int[] termHashes;
                this.ensureNotFlushed();
                for (int hash : termHashes = ES93BloomFilterStoredFieldsFormat.hashTerm(value, this.hashes)) {
                    int posInBitArray = hash & this.bitsetSizeInBits - 1;
                    int pos = posInBitArray >> 3;
                    int mask = 1 << (posInBitArray & 7);
                    byte val = (byte)(this.buffer.get(pos) | mask);
                    this.buffer.set(pos, val);
                }
            }

            private void mergeBloomFiltersWithOr(MergeState mergeState) throws IOException {
                this.ensureNotFlushed();
                for (int readerIdx = 0; readerIdx < mergeState.storedFieldsReaders.length; ++readerIdx) {
                    StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[readerIdx];
                    if (!(storedFieldsReader instanceof Reader)) {
                        throw new IllegalStateException("Expected a Reader but got " + String.valueOf(storedFieldsReader.getClass()));
                    }
                    Reader reader = (Reader)storedFieldsReader;
                    BloomFilterFieldReader bloomFilterFieldReader = reader.bloomFilterFieldReader;
                    if (bloomFilterFieldReader == null) continue;
                    assert (bloomFilterFieldReader.getBloomFilterBitSetSizeInBits() == this.bitsetSizeInBits) : "Expected a bloom filter bitset size " + this.bitsetSizeInBits + " but got " + bloomFilterFieldReader.getBloomFilterBitSetSizeInBits();
                    bloomFilterFieldReader.checkIntegrity();
                    IndexInput bloomFilterData = bloomFilterFieldReader.bloomFilterData;
                    bloomFilterData.prefetch(0L, (long)this.bitSetSizeInBytes);
                    for (int i = 0; i < this.bitSetSizeInBytes; ++i) {
                        byte existingBloomFilterByte = bloomFilterData.readByte();
                        byte resultingBloomFilterByte = this.buffer.get(i);
                        this.buffer.set(i, (byte)(existingBloomFilterByte | resultingBloomFilterByte));
                    }
                }
            }

            private BloomFilterMetadata finish() throws IOException {
                this.ensureNotFlushed();
                BloomFilterMetadata bloomFilterMetadata = new BloomFilterMetadata(this.fieldInfo, this.bloomFilterDataOut.getFilePointer(), this.bitsetSizeInBits, Writer.this.numHashFunctions);
                if (this.buffer.hasArray()) {
                    this.bloomFilterDataOut.writeBytes(this.buffer.array(), 0, this.bitSetSizeInBytes);
                } else {
                    BytesReference.fromByteArray(this.buffer, this.bitSetSizeInBytes).writeTo(new IndexOutputOutputStream(this.bloomFilterDataOut));
                }
                CodecUtil.writeFooter((IndexOutput)this.bloomFilterDataOut);
                this.flushed = true;
                return bloomFilterMetadata;
            }

            private void ensureNotFlushed() {
                if (this.flushed) {
                    throw new IllegalStateException("Bloom filter has already been flushed");
                }
            }

            @Override
            public void close() throws IOException {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.bloomFilterDataOut, this.buffer});
            }
        }
    }

    public static interface BloomFilterProvider
    extends Closeable {
        @Nullable
        public BloomFilter getBloomFilter() throws IOException;
    }

    public static interface BloomFilter
    extends Closeable {
        public boolean mayContainTerm(String var1, BytesRef var2) throws IOException;
    }

    static class BloomFilterFieldReader
    implements BloomFilter {
        private final FieldInfo fieldInfo;
        private final IndexInput bloomFilterData;
        private final RandomAccessInput bloomFilterIn;
        private final int bloomFilterBitSetSizeInBits;
        private final int[] hashes;

        @Nullable
        static BloomFilterFieldReader open(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context, String segmentSuffix) throws IOException {
            ArrayList<IndexInput> toClose = new ArrayList<IndexInput>();
            boolean success = false;
            try {
                BloomFilterFieldReader bloomFilterFieldReader;
                block15: {
                    int metadataVersion;
                    ChecksumIndexInput metaInput;
                    block13: {
                        BloomFilterFieldReader bloomFilterFieldReader2;
                        block14: {
                            metaInput = directory.openChecksumInput(ES93BloomFilterStoredFieldsFormat.bloomFilterMetadataFileName(si, segmentSuffix));
                            try {
                                boolean hasBloomFilter;
                                metadataVersion = CodecUtil.checkIndexHeader((DataInput)metaInput, (String)ES93BloomFilterStoredFieldsFormat.STORED_FIELDS_BLOOM_FILTER_FORMAT_NAME, (int)0, (int)0, (byte[])si.getId(), (String)segmentSuffix);
                                boolean bl = hasBloomFilter = metaInput.readByte() == 1;
                                if (hasBloomFilter) break block13;
                                bloomFilterFieldReader2 = null;
                                if (metaInput == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (metaInput != null) {
                                    try {
                                        metaInput.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            metaInput.close();
                        }
                        return bloomFilterFieldReader2;
                    }
                    BloomFilterMetadata bloomFilterMetadata = BloomFilterMetadata.readFrom((IndexInput)metaInput, fn);
                    CodecUtil.checkFooter((ChecksumIndexInput)metaInput);
                    IndexInput bloomFilterData = directory.openInput(ES93BloomFilterStoredFieldsFormat.bloomFilterFileName(si, segmentSuffix), context);
                    toClose.add(bloomFilterData);
                    int bloomFilterDataVersion = CodecUtil.checkIndexHeader((DataInput)bloomFilterData, (String)ES93BloomFilterStoredFieldsFormat.STORED_FIELDS_BLOOM_FILTER_FORMAT_NAME, (int)0, (int)0, (byte[])si.getId(), (String)segmentSuffix);
                    if (metadataVersion != bloomFilterDataVersion) {
                        throw new CorruptIndexException("Format versions mismatch: meta=" + metadataVersion + ", data=" + bloomFilterDataVersion, (DataInput)bloomFilterData);
                    }
                    CodecUtil.checksumEntireFile((IndexInput)bloomFilterData);
                    BloomFilterFieldReader bloomFilterFieldReader3 = new BloomFilterFieldReader(bloomFilterMetadata.fieldInfo(), bloomFilterData.randomAccessSlice(bloomFilterMetadata.fileOffset(), (long)bloomFilterMetadata.sizeInBytes()), bloomFilterMetadata.sizeInBits(), bloomFilterMetadata.numHashFunctions(), bloomFilterData);
                    success = true;
                    bloomFilterFieldReader = bloomFilterFieldReader3;
                    if (metaInput == null) break block15;
                    metaInput.close();
                }
                return bloomFilterFieldReader;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(toClose);
                }
            }
        }

        BloomFilterFieldReader(FieldInfo fieldInfo, RandomAccessInput bloomFilterIn, int bloomFilterBitSetSizeInBits, int numHashFunctions, IndexInput bloomFilterData) {
            this.fieldInfo = Objects.requireNonNull(fieldInfo);
            this.bloomFilterIn = bloomFilterIn;
            this.bloomFilterBitSetSizeInBits = bloomFilterBitSetSizeInBits;
            this.hashes = new int[numHashFunctions];
            this.bloomFilterData = bloomFilterData;
        }

        @Override
        public boolean mayContainTerm(String field, BytesRef term) throws IOException {
            int[] termHashes;
            assert (this.fieldInfo.getName().equals(field));
            for (int hash : termHashes = ES93BloomFilterStoredFieldsFormat.hashTerm(term, this.hashes)) {
                int posInBitArray = hash & this.bloomFilterBitSetSizeInBits - 1;
                int pos = posInBitArray >> 3;
                int mask = 1 << (posInBitArray & 7);
                byte bits = this.bloomFilterIn.readByte((long)pos);
                if ((bits & mask) != 0) continue;
                return false;
            }
            return true;
        }

        int getBloomFilterBitSetSizeInBits() {
            return this.bloomFilterBitSetSizeInBits;
        }

        void checkIntegrity() throws IOException {
            CodecUtil.checksumEntireFile((IndexInput)this.bloomFilterData);
        }

        @Override
        public void close() throws IOException {
            this.bloomFilterData.close();
        }
    }

    record BloomFilterMetadata(FieldInfo fieldInfo, long fileOffset, int sizeInBits, int numHashFunctions) {
        BloomFilterMetadata {
            assert (fieldInfo != null);
            assert (ES93BloomFilterStoredFieldsFormat.isPowerOfTwo(sizeInBits));
        }

        int sizeInBytes() {
            return this.sizeInBits / 8;
        }

        void writeTo(IndexOutput indexOut) throws IOException {
            indexOut.writeVInt(this.fieldInfo.number);
            indexOut.writeVLong(this.fileOffset);
            indexOut.writeVInt(this.sizeInBits);
            indexOut.writeVInt(this.numHashFunctions);
        }

        static BloomFilterMetadata readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            FieldInfo fieldInfo = fieldInfos.fieldInfo(in.readVInt());
            long fileOffset = in.readVLong();
            int bloomFilterSizeInBits = in.readVInt();
            int numOfHashFunctions = in.readVInt();
            return new BloomFilterMetadata(fieldInfo, fileOffset, bloomFilterSizeInBits, numOfHashFunctions);
        }
    }
}

