/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

public class ThrottlingAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ThrottlingAllocationDecider.class);
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES = 2;
    public static final int DEFAULT_CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES = 4;
    public static final String NAME = "throttling";
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_recoveries", Integer.toString(2), s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING = Setting.intSetting("cluster.routing.allocation.node_initial_primaries_recoveries", 4, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_incoming_recoveries", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_incoming_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING = new Setting<Integer>("cluster.routing.allocation.node_concurrent_outgoing_recoveries", CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING, s -> Setting.parseInt(s, 0, "cluster.routing.allocation.node_concurrent_outgoing_recoveries"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_UNTHROTTLE_REPLICA_ASSIGNMENT_IN_SIMULATION = Setting.boolSetting("cluster.routing.allocation.unthrottle_replica_assignment_in_simulation", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int primariesInitialRecoveries;
    private volatile int concurrentIncomingRecoveries;
    private volatile int concurrentOutgoingRecoveries;
    private volatile boolean unthrottleReplicaAssignmentInSimulation = false;

    public ThrottlingAllocationDecider(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING, this::setPrimariesInitialRecoveries);
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING, this::setConcurrentIncomingRecoverries);
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING, this::setConcurrentOutgoingRecoverries);
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_UNTHROTTLE_REPLICA_ASSIGNMENT_IN_SIMULATION, settingVal -> {
            this.unthrottleReplicaAssignmentInSimulation = settingVal;
        });
        logger.debug("using node_concurrent_outgoing_recoveries [{}], node_concurrent_incoming_recoveries [{}], node_initial_primaries_recoveries [{}]", (Object)this.concurrentOutgoingRecoveries, (Object)this.concurrentIncomingRecoveries, (Object)this.primariesInitialRecoveries);
    }

    private void setConcurrentIncomingRecoverries(int concurrentIncomingRecoveries) {
        this.concurrentIncomingRecoveries = concurrentIncomingRecoveries;
    }

    private void setConcurrentOutgoingRecoverries(int concurrentOutgoingRecoveries) {
        this.concurrentOutgoingRecoveries = concurrentOutgoingRecoveries;
    }

    private void setPrimariesInitialRecoveries(int primariesInitialRecoveries) {
        this.primariesInitialRecoveries = primariesInitialRecoveries;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary() && shardRouting.unassigned()) {
            assert (ThrottlingAllocationDecider.initializingShard(shardRouting, node.nodeId()).recoverySource().getType() != RecoverySource.Type.PEER);
            if (allocation.isSimulating()) {
                return allocation.decision(Decision.YES, NAME, "primary allocation is not throttled when simulating", new Object[0]);
            }
            int primariesInRecovery = 0;
            boolean returnUnexplainedDecision = !allocation.debugDecision();
            for (ShardRouting shard : node.initializing()) {
                if (!shard.primary() || shard.relocatingNodeId() != null || !returnUnexplainedDecision || ++primariesInRecovery < this.primariesInitialRecoveries) continue;
                return Decision.THROTTLE;
            }
            if (primariesInRecovery >= this.primariesInitialRecoveries) {
                return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of ongoing initial primary recoveries [%d], cluster setting [%s=%d]", primariesInRecovery, CLUSTER_ROUTING_ALLOCATION_NODE_INITIAL_PRIMARIES_RECOVERIES_SETTING.getKey(), this.primariesInitialRecoveries);
            }
            return allocation.decision(Decision.YES, NAME, "below primary recovery limit of [%d]", this.primariesInitialRecoveries);
        }
        if (allocation.isSimulating() && this.unthrottleReplicaAssignmentInSimulation && shardRouting.unassigned()) {
            return allocation.decision(Decision.YES, NAME, "replica allocation is not throttled when simulating", new Object[0]);
        }
        assert (ThrottlingAllocationDecider.initializingShard(shardRouting, node.nodeId()).recoverySource().getType() == RecoverySource.Type.PEER);
        int currentInRecoveries = allocation.routingNodes().getIncomingRecoveries(node.nodeId());
        if (currentInRecoveries >= this.concurrentIncomingRecoveries) {
            return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of incoming shard recoveries [%d], cluster setting [%s=%d] (can also be set via [%s])", currentInRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), this.concurrentIncomingRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING.getKey());
        }
        ShardRouting primaryShard = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primaryShard == null) {
            return allocation.decision(Decision.NO, NAME, "primary shard for this replica is not yet active", new Object[0]);
        }
        int primaryNodeOutRecoveries = allocation.routingNodes().getOutgoingRecoveries(primaryShard.currentNodeId());
        if (primaryNodeOutRecoveries >= this.concurrentOutgoingRecoveries) {
            return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of outgoing shard recoveries [%d] on the node [%s] which holds the primary, cluster setting [%s=%d] (can also be set via [%s])", primaryNodeOutRecoveries, primaryShard.currentNodeId(), CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), this.concurrentOutgoingRecoveries, CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_RECOVERIES_SETTING.getKey());
        }
        return allocation.decision(Decision.YES, NAME, "below shard recovery limit of outgoing: [%d < %d] incoming: [%d < %d]", primaryNodeOutRecoveries, this.concurrentOutgoingRecoveries, currentInRecoveries, this.concurrentIncomingRecoveries);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    public static ShardRouting initializingShard(ShardRouting shardRouting, String currentNodeId) {
        ShardRouting initializingShard;
        if (shardRouting.unassigned()) {
            initializingShard = shardRouting.initialize(currentNodeId, null, -1L);
        } else if (shardRouting.initializing()) {
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (unassignedInfo == null) {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, "fake");
            }
            initializingShard = shardRouting.moveToUnassigned(unassignedInfo).initialize(currentNodeId, null, -1L);
        } else if (shardRouting.relocating()) {
            initializingShard = shardRouting.cancelRelocation().relocate(currentNodeId, -1L).getTargetRelocatingShard();
        } else {
            assert (shardRouting.started());
            initializingShard = shardRouting.relocate(currentNodeId, -1L).getTargetRelocatingShard();
        }
        assert (initializingShard.initializing());
        return initializingShard;
    }
}

