/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ComposableIndexTemplate
implements SimpleDiffable<ComposableIndexTemplate>,
ToXContentObject {
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField PRIORITY = new ParseField("priority", new String[0]);
    private static final ParseField COMPOSED_OF = new ParseField("composed_of", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ParseField ALLOW_AUTO_CREATE = new ParseField("allow_auto_create", new String[0]);
    private static final ParseField IGNORE_MISSING_COMPONENT_TEMPLATES = new ParseField("ignore_missing_component_templates", new String[0]);
    private static final ParseField DEPRECATED = new ParseField("deprecated", new String[0]);
    private static final ParseField CREATED_DATE_MILLIS = new ParseField("created_date_millis", new String[0]);
    private static final ParseField CREATED_DATE = new ParseField("created_date", new String[0]);
    private static final ParseField MODIFIED_DATE_MILLIS = new ParseField("modified_date_millis", new String[0]);
    private static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    public static final CompressedXContent EMPTY_MAPPINGS;
    public static final ConstructingObjectParser<ComposableIndexTemplate, Void> PARSER;
    private static final TransportVersion INDEX_TEMPLATE_TRACKING_INFO;
    private final List<String> indexPatterns;
    @Nullable
    private final Template template;
    @Nullable
    private final List<String> componentTemplates;
    @Nullable
    private final Long priority;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final DataStreamTemplate dataStreamTemplate;
    @Nullable
    private final Boolean allowAutoCreate;
    @Nullable
    private final List<String> ignoreMissingComponentTemplates;
    @Nullable
    private final Boolean deprecated;
    @Nullable
    private final Long createdDateMillis;
    @Nullable
    private final Long modifiedDateMillis;

    static Diff<ComposableIndexTemplate> readITV2DiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ComposableIndexTemplate::new, in);
    }

    public static ComposableIndexTemplate parse(XContentParser parser) throws IOException {
        return (ComposableIndexTemplate)PARSER.parse(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    private ComposableIndexTemplate(Builder b) {
        this.indexPatterns = b.indexPatterns;
        this.template = b.template;
        this.componentTemplates = b.componentTemplates == null ? List.of() : b.componentTemplates;
        this.priority = b.priority;
        this.version = b.version;
        this.metadata = b.metadata;
        this.dataStreamTemplate = b.dataStreamTemplate;
        this.allowAutoCreate = b.allowAutoCreate;
        this.ignoreMissingComponentTemplates = b.ignoreMissingComponentTemplates;
        this.deprecated = b.deprecated;
        this.createdDateMillis = b.createdDateMillis;
        this.modifiedDateMillis = b.modifiedDateMillis;
    }

    public ComposableIndexTemplate(StreamInput in) throws IOException {
        this.indexPatterns = in.readStringCollectionAsList();
        this.template = in.readBoolean() ? new Template(in) : null;
        this.componentTemplates = in.readOptionalStringCollectionAsList();
        this.priority = in.readOptionalVLong();
        this.version = in.readOptionalVLong();
        this.metadata = in.readGenericMap();
        this.dataStreamTemplate = in.readOptionalWriteable(DataStreamTemplate::new);
        this.allowAutoCreate = in.readOptionalBoolean();
        this.ignoreMissingComponentTemplates = in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0) ? in.readOptionalStringCollectionAsList() : null;
        this.deprecated = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readOptionalBoolean() : null;
        if (in.getTransportVersion().supports(INDEX_TEMPLATE_TRACKING_INFO)) {
            this.createdDateMillis = in.readOptionalLong();
            this.modifiedDateMillis = in.readOptionalLong();
        } else {
            this.createdDateMillis = null;
            this.modifiedDateMillis = null;
        }
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public Template template() {
        return this.template;
    }

    public List<String> composedOf() {
        if (this.componentTemplates == null) {
            return List.of();
        }
        return this.componentTemplates;
    }

    public List<String> getRequiredComponentTemplates() {
        if (this.componentTemplates == null) {
            return List.of();
        }
        if (this.ignoreMissingComponentTemplates == null) {
            return this.componentTemplates;
        }
        ArrayList<String> required = new ArrayList<String>(this.componentTemplates.size());
        for (String template : this.componentTemplates) {
            if (this.ignoreMissingComponentTemplates.contains(template)) continue;
            required.add(template);
        }
        return Collections.unmodifiableList(required);
    }

    @Nullable
    public Long priority() {
        return this.priority;
    }

    public long priorityOrZero() {
        if (this.priority == null) {
            return 0L;
        }
        return this.priority;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Nullable
    public DataStreamTemplate getDataStreamTemplate() {
        return this.dataStreamTemplate;
    }

    @Nullable
    public Boolean getAllowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nullable
    public List<String> getIgnoreMissingComponentTemplates() {
        return this.ignoreMissingComponentTemplates;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    public Optional<Long> createdDateMillis() {
        return Optional.ofNullable(this.createdDateMillis);
    }

    public Optional<Long> modifiedDateMillis() {
        return Optional.ofNullable(this.modifiedDateMillis);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indexPatterns);
        if (this.template == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.template.writeTo(out);
        }
        out.writeOptionalStringCollection(this.componentTemplates);
        out.writeOptionalVLong(this.priority);
        out.writeOptionalVLong(this.version);
        out.writeGenericMap(this.metadata);
        out.writeOptionalWriteable(this.dataStreamTemplate);
        out.writeOptionalBoolean(this.allowAutoCreate);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            out.writeOptionalStringCollection(this.ignoreMissingComponentTemplates);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalBoolean(this.deprecated);
        }
        if (out.getTransportVersion().supports(INDEX_TEMPLATE_TRACKING_INFO)) {
            out.writeOptionalLong(this.createdDateMillis);
            out.writeOptionalLong(this.modifiedDateMillis);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
        builder.startObject();
        builder.stringListField(INDEX_PATTERNS.getPreferredName(), this.indexPatterns);
        if (this.template != null) {
            builder.field(TEMPLATE.getPreferredName());
            this.template.toXContent(builder, params, rolloverConfiguration);
        }
        if (this.componentTemplates != null) {
            builder.stringListField(COMPOSED_OF.getPreferredName(), this.componentTemplates);
        }
        if (this.priority != null) {
            builder.field(PRIORITY.getPreferredName(), this.priority);
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.dataStreamTemplate != null) {
            builder.field(DATA_STREAM.getPreferredName(), (ToXContent)this.dataStreamTemplate, params);
        }
        if (this.allowAutoCreate != null) {
            builder.field(ALLOW_AUTO_CREATE.getPreferredName(), this.allowAutoCreate);
        }
        if (this.ignoreMissingComponentTemplates != null) {
            builder.stringListField(IGNORE_MISSING_COMPONENT_TEMPLATES.getPreferredName(), this.ignoreMissingComponentTemplates);
        }
        if (this.deprecated != null) {
            builder.field(DEPRECATED.getPreferredName(), this.deprecated);
        }
        if (this.createdDateMillis != null) {
            builder.timestampFieldsFromUnixEpochMillis(CREATED_DATE_MILLIS.getPreferredName(), CREATED_DATE.getPreferredName(), this.createdDateMillis.longValue());
        }
        if (this.modifiedDateMillis != null) {
            builder.timestampFieldsFromUnixEpochMillis(MODIFIED_DATE_MILLIS.getPreferredName(), MODIFIED_DATE.getPreferredName(), this.modifiedDateMillis.longValue());
        }
        builder.endObject();
        return builder;
    }

    public ComposableIndexTemplate mergeSettings(Settings settings) {
        Settings templateSettings;
        Template.Builder mergedTemplateBuilder;
        Objects.requireNonNull(settings);
        if (Settings.EMPTY.equals(settings)) {
            return this;
        }
        Builder mergedIndexTemplateBuilder = this.toBuilder();
        if (this.template() == null) {
            mergedTemplateBuilder = Template.builder();
            templateSettings = null;
        } else {
            mergedTemplateBuilder = Template.builder(this.template());
            templateSettings = this.template().settings();
        }
        mergedTemplateBuilder.settings(templateSettings == null ? settings : templateSettings.merge(settings));
        mergedIndexTemplateBuilder.template(mergedTemplateBuilder);
        return mergedIndexTemplateBuilder.build();
    }

    public ComposableIndexTemplate mergeMappings(CompressedXContent mappings) throws IOException {
        CompressedXContent templateMappings;
        Template.Builder mergedTemplateBuilder;
        Objects.requireNonNull(mappings);
        if (Mapping.EMPTY.toCompressedXContent().equals(mappings) && this.template() != null && this.template().mappings() != null) {
            return this;
        }
        Builder mergedIndexTemplateBuilder = this.toBuilder();
        if (this.template() == null) {
            mergedTemplateBuilder = Template.builder();
            templateMappings = null;
        } else {
            mergedTemplateBuilder = Template.builder(this.template());
            templateMappings = this.template().mappings();
        }
        mergedTemplateBuilder.mappings(templateMappings == null ? mappings : ComposableIndexTemplate.merge(templateMappings, mappings));
        mergedIndexTemplateBuilder.template(mergedTemplateBuilder);
        return mergedIndexTemplateBuilder.build();
    }

    public static CompressedXContent merge(CompressedXContent originalMapping, CompressedXContent mappingAddition) throws IOException {
        Map mappingAdditionMap = (Map)XContentHelper.convertToMap(mappingAddition.uncompressed(), true, XContentType.JSON).v2();
        HashMap<String, Object> combinedMappingMap = new HashMap<String, Object>();
        if (originalMapping != null) {
            Map originalMappingMap = (Map)XContentHelper.convertToMap(originalMapping.uncompressed(), true, XContentType.JSON).v2();
            if (originalMappingMap.containsKey("_doc")) {
                combinedMappingMap.putAll((Map)originalMappingMap.get("_doc"));
            } else {
                combinedMappingMap.putAll(originalMappingMap);
            }
        }
        XContentHelper.update(combinedMappingMap, mappingAdditionMap, true);
        return ComposableIndexTemplate.convertMappingMapToXContent(combinedMappingMap);
    }

    public static CompressedXContent convertMappingMapToXContent(Map<String, ?> rawAdditionalMapping) throws IOException {
        CompressedXContent compressedXContent;
        if (rawAdditionalMapping.isEmpty()) {
            compressedXContent = EMPTY_MAPPINGS;
        } else {
            try (XContentParser parser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, rawAdditionalMapping);){
                compressedXContent = ComposableIndexTemplate.mappingFromXContent(parser);
            }
        }
        return compressedXContent;
    }

    private static CompressedXContent mappingFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            return new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(parser.mapOrdered())));
        }
        throw new IllegalArgumentException("Unexpected token: " + String.valueOf(token));
    }

    public int hashCode() {
        return Objects.hash(this.indexPatterns, this.template, this.componentTemplates, this.priority, this.version, this.metadata, this.dataStreamTemplate, this.allowAutoCreate, this.ignoreMissingComponentTemplates, this.deprecated, this.createdDateMillis, this.modifiedDateMillis);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComposableIndexTemplate other = (ComposableIndexTemplate)obj;
        return Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.template, other.template) && ComposableIndexTemplate.componentTemplatesEquals(this.componentTemplates, other.componentTemplates) && Objects.equals(this.priority, other.priority) && Objects.equals(this.version, other.version) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.dataStreamTemplate, other.dataStreamTemplate) && Objects.equals(this.allowAutoCreate, other.allowAutoCreate) && Objects.equals(this.ignoreMissingComponentTemplates, other.ignoreMissingComponentTemplates) && Objects.equals(this.deprecated, other.deprecated) && Objects.equals(this.createdDateMillis, other.createdDateMillis) && Objects.equals(this.modifiedDateMillis, other.modifiedDateMillis);
    }

    static boolean componentTemplatesEquals(List<String> c1, List<String> c2) {
        if (Objects.equals(c1, c2)) {
            return true;
        }
        if (c1 == null && c2.isEmpty()) {
            return true;
        }
        return c2 == null && c1.isEmpty();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        try {
            EMPTY_MAPPINGS = new CompressedXContent(Map.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PARSER = new ConstructingObjectParser("index_template", false, a -> ComposableIndexTemplate.builder().indexPatterns((List)a[0]).template((Template)a[1]).componentTemplates((List)a[2]).priority((Long)a[3]).version((Long)a[4]).metadata((Map)a[5]).dataStreamTemplate((DataStreamTemplate)a[6]).allowAutoCreate((Boolean)a[7]).ignoreMissingComponentTemplates((List)a[8]).deprecated((Boolean)a[9]).createdDate((Long)a[10]).modifiedDate((Long)a[11]).build());
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX_PATTERNS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Template.PARSER, TEMPLATE);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), COMPOSED_OF);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PRIORITY);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataStreamTemplate.PARSER, DATA_STREAM);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_AUTO_CREATE);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), IGNORE_MISSING_COMPONENT_TEMPLATES);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DEPRECATED);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CREATED_DATE_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MODIFIED_DATE_MILLIS);
        INDEX_TEMPLATE_TRACKING_INFO = TransportVersion.fromName("index_template_tracking_info");
    }

    public static class Builder {
        private List<String> indexPatterns;
        private Template template;
        private List<String> componentTemplates;
        private Long priority;
        private Long version;
        private Map<String, Object> metadata;
        private DataStreamTemplate dataStreamTemplate;
        private Boolean allowAutoCreate;
        private List<String> ignoreMissingComponentTemplates;
        private Boolean deprecated;
        private Long createdDateMillis;
        private Long modifiedDateMillis;

        @Deprecated(forRemoval=true)
        public Builder() {
        }

        private Builder(ComposableIndexTemplate template) {
            this.indexPatterns = template.indexPatterns;
            this.template = template.template;
            this.componentTemplates = template.componentTemplates;
            this.priority = template.priority;
            this.version = template.version;
            this.metadata = template.metadata;
            this.dataStreamTemplate = template.dataStreamTemplate;
            this.allowAutoCreate = template.allowAutoCreate;
            this.ignoreMissingComponentTemplates = template.ignoreMissingComponentTemplates;
            this.deprecated = template.deprecated;
            this.createdDateMillis = template.createdDateMillis;
            this.modifiedDateMillis = template.modifiedDateMillis;
        }

        public Builder indexPatterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            return this;
        }

        public Builder template(Template.Builder template) {
            this.template = template.build();
            return this;
        }

        public Builder componentTemplates(List<String> componentTemplates) {
            this.componentTemplates = componentTemplates;
            return this;
        }

        public Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder dataStreamTemplate(DataStreamTemplate dataStreamTemplate) {
            this.dataStreamTemplate = dataStreamTemplate;
            return this;
        }

        public Builder allowAutoCreate(Boolean allowAutoCreate) {
            this.allowAutoCreate = allowAutoCreate;
            return this;
        }

        public Builder ignoreMissingComponentTemplates(List<String> ignoreMissingComponentTemplates) {
            this.ignoreMissingComponentTemplates = ignoreMissingComponentTemplates;
            return this;
        }

        public Builder deprecated(@Nullable Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder createdDate(@Nullable Long createdDate) {
            this.createdDateMillis = createdDate;
            return this;
        }

        public Builder modifiedDate(@Nullable Long modifiedDate) {
            this.modifiedDateMillis = modifiedDate;
            return this;
        }

        public ComposableIndexTemplate build() {
            return new ComposableIndexTemplate(this);
        }
    }

    public static class DataStreamTemplate
    implements Writeable,
    ToXContentObject {
        private static final ParseField HIDDEN = new ParseField("hidden", new String[0]);
        private static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
        private static final ParseField FAILURE_STORE = new ParseField("failure_store", new String[0]);
        public static final ConstructingObjectParser<DataStreamTemplate, Void> PARSER = new ConstructingObjectParser("data_stream_template", false, args -> new DataStreamTemplate(args[0] != null && (Boolean)args[0] != false, args[1] != null && (Boolean)args[1] != false));
        private final boolean hidden;
        private final boolean allowCustomRouting;
        public static final CompressedXContent DATA_STREAM_MAPPING_SNIPPET;

        public DataStreamTemplate() {
            this(false, false);
        }

        public DataStreamTemplate(boolean hidden, boolean allowCustomRouting) {
            this.hidden = hidden;
            this.allowCustomRouting = allowCustomRouting;
        }

        DataStreamTemplate(StreamInput in) throws IOException {
            this.hidden = in.readBoolean();
            this.allowCustomRouting = in.readBoolean();
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isAllowCustomRouting() {
            return this.allowCustomRouting;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.hidden);
            out.writeBoolean(this.allowCustomRouting);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("hidden", this.hidden);
            builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.allowCustomRouting);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStreamTemplate that = (DataStreamTemplate)o;
            return this.hidden == that.hidden && this.allowCustomRouting == that.allowCustomRouting;
        }

        public int hashCode() {
            return Objects.hash(this.hidden, this.allowCustomRouting);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_CUSTOM_ROUTING);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FAILURE_STORE);
            try {
                DATA_STREAM_MAPPING_SNIPPET = new CompressedXContent((builder, params) -> builder.field("_doc", Map.of("_data_stream_timestamp", Map.of("enabled", true))));
            }
            catch (IOException e) {
                throw new AssertionError("no actual IO happens here", e);
            }
        }
    }
}

