/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateRequest;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportResetFeatureStateAction
extends TransportMasterNodeAction<ResetFeatureStateRequest, ResetFeatureStateResponse> {
    public static final ActionType<ResetFeatureStateResponse> TYPE = new ActionType("cluster:admin/features/reset");
    private final SystemIndices systemIndices;
    private final NodeClient client;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportResetFeatureStateAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, SystemIndices systemIndices, NodeClient client, ClusterService clusterService, ProjectResolver projectResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, ResetFeatureStateRequest::fromStream, ResetFeatureStateResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndices = systemIndices;
        this.client = client;
        this.projectResolver = projectResolver;
    }

    @Override
    protected void masterOperation(Task task, ResetFeatureStateRequest request, ClusterState state, ActionListener<ResetFeatureStateResponse> listener) throws Exception {
        Collection<SystemIndices.Feature> features = this.systemIndices.getFeatures();
        ArrayList responses = new ArrayList(features.size());
        try (RefCountingListener listeners = new RefCountingListener(listener.map(ignored -> new ResetFeatureStateResponse(Collections.unmodifiableList(responses))));){
            for (SystemIndices.Feature feature : features) {
                feature.getCleanUpFunction().apply(this.clusterService, this.projectResolver, this.client, request.masterNodeTimeout(), listeners.acquire(e -> {
                    assert (e != null) : feature.getName();
                    ArrayList arrayList = responses;
                    synchronized (arrayList) {
                        responses.add(e);
                    }
                }));
            }
        }
    }

    @Override
    protected ClusterBlockException checkBlock(ResetFeatureStateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

