/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests.middleware;

import com.microsoft.graph.core.requests.options.GraphClientOption;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class GraphTelemetryHandler
implements Interceptor {
    private GraphClientOption mGraphClientOption;
    private String androidAPILevel;

    public GraphTelemetryHandler() {
        this(new GraphClientOption());
    }

    public GraphTelemetryHandler(@Nonnull GraphClientOption graphClientOption) {
        this.mGraphClientOption = Objects.requireNonNull(graphClientOption);
    }

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder telemetryAddedBuilder = request.newBuilder();
        String clientLibraryUsed = "graph-java" + (this.mGraphClientOption.getGraphServiceTargetVersion().equals("v1.0") ? "" : "-" + this.mGraphClientOption.getGraphServiceTargetVersion());
        String sdkVersion = this.mGraphClientOption.getClientLibraryVersion() == null ? "" : "/" + this.mGraphClientOption.getClientLibraryVersion();
        String coreVersionHeader = "graph-java-core/" + this.mGraphClientOption.getCoreLibraryVersion();
        String featureUsage = "(featureUsage=" + this.mGraphClientOption.featureTracker.getSerializedFeatureUsage();
        String jreVersion = System.getProperty("java.version");
        String jreVersionHeader = "0".equals(jreVersion) ? "" : "; runtimeEnvironment=JRE/" + jreVersion;
        String androidVersion = this.getAndroidAPILevel();
        String androidVersionHeader = "0".equals(androidVersion) ? "" : "; android/" + androidVersion;
        String sdkTelemetry = clientLibraryUsed + sdkVersion + ", " + coreVersionHeader + " " + featureUsage + jreVersionHeader + androidVersionHeader + ")";
        telemetryAddedBuilder.addHeader("SdkVersion", sdkTelemetry);
        if (request.header("client-request-id") == null) {
            telemetryAddedBuilder.addHeader("client-request-id", this.mGraphClientOption.getClientRequestId());
        }
        return chain.proceed(telemetryAddedBuilder.build());
    }

    private String getAndroidAPILevel() {
        if (this.androidAPILevel == null) {
            this.androidAPILevel = this.getAndroidAPILevelInternal();
        }
        return this.androidAPILevel;
    }

    private String getAndroidAPILevelInternal() {
        try {
            Class<?> buildClass = Class.forName("android.os.Build");
            Class<?>[] subclasses = buildClass.getDeclaredClasses();
            Class<?> versionClass = null;
            for (Class<?> subclass : subclasses) {
                if (!subclass.getName().endsWith("VERSION")) continue;
                versionClass = subclass;
                break;
            }
            if (versionClass == null) {
                return "0";
            }
            Field sdkVersionField = versionClass.getField("SDK_INT");
            Object value = sdkVersionField.get(null);
            String valueStr = String.valueOf(value);
            return valueStr == null || valueStr.equals("") ? "0" : valueStr;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
            return "0";
        }
    }
}

