/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportLink;

class TransportSender
extends TransportLink<SenderImpl> {
    private boolean _drain;
    private DeliveryImpl _inProgressDelivery;
    private static final UnsignedInteger ORIGINAL_DELIVERY_COUNT = UnsignedInteger.ZERO;

    TransportSender(SenderImpl link) {
        super(link);
        this.setDeliveryCount(ORIGINAL_DELIVERY_COUNT);
        link.setTransportLink(this);
    }

    @Override
    void handleFlow(Flow flow) {
        super.handleFlow(flow);
        this._drain = flow.getDrain();
        ((SenderImpl)this.getLink()).setDrain(flow.getDrain());
        int oldCredit = ((SenderImpl)this.getLink()).getCredit();
        UnsignedInteger oldLimit = this.getLinkCredit().add(this.getDeliveryCount());
        UnsignedInteger transferLimit = flow.getLinkCredit().add(flow.getDeliveryCount() == null ? ORIGINAL_DELIVERY_COUNT : flow.getDeliveryCount());
        UnsignedInteger linkCredit = transferLimit.subtract(this.getDeliveryCount());
        this.setLinkCredit(linkCredit);
        ((SenderImpl)this.getLink()).setCredit(transferLimit.subtract(oldLimit).intValue() + oldCredit);
        DeliveryImpl current = ((SenderImpl)this.getLink()).current();
        ((SenderImpl)this.getLink()).getConnectionImpl().workUpdate(current);
        this.setLinkCredit(linkCredit);
    }

    public void setInProgressDelivery(DeliveryImpl inProgressDelivery) {
        this._inProgressDelivery = inProgressDelivery;
    }

    public DeliveryImpl getInProgressDelivery() {
        return this._inProgressDelivery;
    }
}

