/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import org.logstash.ackedqueue.CompressionCodec;
import org.logstash.ackedqueue.Queueable;
import org.logstash.ackedqueue.Settings;

public class SettingsImpl
implements Settings {
    private final String dirForFiles;
    private final Class<? extends Queueable> elementClass;
    private final int capacity;
    private final long queueMaxBytes;
    private final int maxUnread;
    private final int checkpointMaxAcks;
    private final int checkpointMaxWrites;
    private final boolean checkpointRetry;
    private final CompressionCodec.Factory compressionCodec;

    public static Settings.Builder builder(Settings settings) {
        return new BuilderImpl(settings);
    }

    public static Settings.Builder fileSettingsBuilder(String dirForFiles) {
        return new BuilderImpl(dirForFiles);
    }

    private SettingsImpl(BuilderImpl builder) {
        this.dirForFiles = builder.dirForFiles;
        this.elementClass = builder.elementClass;
        this.capacity = builder.capacity;
        this.queueMaxBytes = builder.queueMaxBytes;
        this.maxUnread = builder.maxUnread;
        this.checkpointMaxAcks = builder.checkpointMaxAcks;
        this.checkpointMaxWrites = builder.checkpointMaxWrites;
        this.checkpointRetry = builder.checkpointRetry;
        this.compressionCodec = builder.compressionCodecFactory;
    }

    @Override
    public int getCheckpointMaxAcks() {
        return this.checkpointMaxAcks;
    }

    @Override
    public int getCheckpointMaxWrites() {
        return this.checkpointMaxWrites;
    }

    @Override
    public Class<? extends Queueable> getElementClass() {
        return this.elementClass;
    }

    @Override
    public String getDirPath() {
        return this.dirForFiles;
    }

    @Override
    public long getQueueMaxBytes() {
        return this.queueMaxBytes;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getMaxUnread() {
        return this.maxUnread;
    }

    @Override
    public boolean getCheckpointRetry() {
        return this.checkpointRetry;
    }

    @Override
    public CompressionCodec.Factory getCompressionCodecFactory() {
        return this.compressionCodec;
    }

    private static final class BuilderImpl
    implements Settings.Builder {
        private static final int DEFAULT_CAPACITY = 0;
        private static final long DEFAULT_MAX_QUEUE_BYTES = 0L;
        private static final int DEFAULT_MAX_UNREAD = 0;
        private static final int DEFAULT_CHECKPOINT_MAX_ACKS = 1024;
        private static final int DEFAULT_CHECKPOINT_MAX_WRITES = 1024;
        private final String dirForFiles;
        private Class<? extends Queueable> elementClass;
        private int capacity;
        private long queueMaxBytes;
        private int maxUnread;
        private int checkpointMaxAcks;
        private int checkpointMaxWrites;
        private boolean checkpointRetry;
        private CompressionCodec.Factory compressionCodecFactory;

        private BuilderImpl(String dirForFiles) {
            this.dirForFiles = dirForFiles;
            this.elementClass = null;
            this.capacity = 0;
            this.queueMaxBytes = 0L;
            this.maxUnread = 0;
            this.checkpointMaxAcks = 1024;
            this.checkpointMaxWrites = 1024;
            this.compressionCodecFactory = metric -> CompressionCodec.NOOP;
            this.checkpointRetry = false;
        }

        private BuilderImpl(Settings settings) {
            this.dirForFiles = settings.getDirPath();
            this.elementClass = settings.getElementClass();
            this.capacity = settings.getCapacity();
            this.queueMaxBytes = settings.getQueueMaxBytes();
            this.maxUnread = settings.getMaxUnread();
            this.checkpointMaxAcks = settings.getCheckpointMaxAcks();
            this.checkpointMaxWrites = settings.getCheckpointMaxWrites();
            this.checkpointRetry = settings.getCheckpointRetry();
            this.compressionCodecFactory = settings.getCompressionCodecFactory();
        }

        @Override
        public Settings.Builder elementClass(Class<? extends Queueable> elementClass) {
            this.elementClass = elementClass;
            return this;
        }

        @Override
        public Settings.Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public Settings.Builder queueMaxBytes(long size) {
            this.queueMaxBytes = size;
            return this;
        }

        @Override
        public Settings.Builder maxUnread(int maxUnread) {
            this.maxUnread = maxUnread;
            return this;
        }

        @Override
        public Settings.Builder checkpointMaxAcks(int checkpointMaxAcks) {
            this.checkpointMaxAcks = checkpointMaxAcks;
            return this;
        }

        @Override
        public Settings.Builder checkpointMaxWrites(int checkpointMaxWrites) {
            this.checkpointMaxWrites = checkpointMaxWrites;
            return this;
        }

        @Override
        public Settings.Builder checkpointRetry(boolean checkpointRetry) {
            this.checkpointRetry = checkpointRetry;
            return this;
        }

        @Override
        public Settings.Builder compressionCodecFactory(CompressionCodec.Factory compressionCodec) {
            this.compressionCodecFactory = compressionCodec;
            return this;
        }

        @Override
        public Settings build() {
            return Settings.ensureValid(new SettingsImpl(this));
        }
    }
}

