"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecondaryMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _item = require("./item");
var _section = require("./section");
var _use_menu_header_style = require("../../hooks/use_menu_header_style");
var _beta_badge = require("../beta_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/secondary_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This menu is reused between the side nav panel and the side nav popover.
 */
const SecondaryMenuBase = /*#__PURE__*/(0, _react.forwardRef)(({
  badgeType,
  children,
  isPanel = false,
  title
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerStyle = (0, _use_menu_header_style.useMenuHeaderStyle)();
  const titleWithBadgeStyles = (0, _react2.css)`
      display: flex;
      align-items: center;
      gap: ${euiTheme.size.xs};
    `;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: (0, _react2.css)`
            ${headerStyle}
            background: ${isPanel ? euiTheme.colors.backgroundBaseSubdued : euiTheme.colors.backgroundBasePlain};
            border-radius: ${euiTheme.border.radius.medium};
          `,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: titleWithBadgeStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, title), badgeType && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    type: badgeType,
    alignment: "text-bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 27
    }
  }))), children);
});
const SecondaryMenu = exports.SecondaryMenu = Object.assign(SecondaryMenuBase, {
  Item: _item.SecondaryMenuItemComponent,
  Section: _section.SecondaryMenuSectionComponent
});