"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BetaBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/beta_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * A badge to indicate that a feature is in beta.
 * It can be aligned to the middle or bottom of the text.
 *
 * TODO: support `bottom` and `text-bottom` alignment in EUI
 */
const BetaBadge = ({
  type,
  isInverted,
  alignment = 'bottom'
}) => {
  const betaBadgeStyles = (0, _react2.css)`
    vertical-align: ${alignment === 'text-bottom' ? 'text-bottom' : 'bottom'};
  `;
  const config = type === 'techPreview' ? {
    iconType: 'flask',
    label: _i18n.i18n.translate('core.ui.chrome.sideNavigation.techPreviewBadgeLabel', {
      defaultMessage: 'Tech preview'
    })
  } : {
    iconType: 'beta',
    label: _i18n.i18n.translate('core.ui.chrome.sideNavigation.betaBadgeLabel', {
      defaultMessage: 'Beta'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: isInverted ? 'dark' : undefined,
    wrapperProps: {
      cloneElement: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: betaBadgeStyles,
    iconType: config.iconType,
    label: config.label,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
};
exports.BetaBadge = BetaBadge;