"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tourSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _deeplinksManagement = require("@kbn/deeplinks-management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation-tour/src/tour_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const newNavBlogPost = 'https://ela.st/new-nav';
const tourSteps = exports.tourSteps = [{
  id: 'sidenav-home',
  required: true,
  // tour won't start if this step is not visible
  title: _i18n.i18n.translate('core.chrome.navigationTour.sidenavHomeTitle', {
    defaultMessage: 'Improved navigation menu'
  }),
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.chrome.navigationTour.sidenavHomeMessage",
    defaultMessage: "The navigation now gives you more workspace and lets you access submenus on hover. Its improved collapsed mode preserves quick access to all menus using icons.{br}{learnMore}",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: newNavBlogPost,
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('core.chrome.navigationTour.learnModeLink', {
        defaultMessage: 'Learn more'
      })),
      br: /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 19
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 11
    }
  }))),
  target: '[data-test-subj~="projectSideNav"] [data-test-subj~="nav-item-home"]'
}, {
  id: 'sidenav-more',
  required: false,
  // tour will continue even if this step is not visible
  title: _i18n.i18n.translate('core.chrome.navigationTour.sidenavMoreTitle', {
    defaultMessage: 'All of your apps are still available'
  }),
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.chrome.navigationTour.sidenavMoreMessage",
    defaultMessage: "You can still access apps that were previously in the navigation menu by selecting <b>More</b>.",
    values: {
      b: chunks => /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 30
        }
      }, chunks)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))),
  target: `[data-test-subj~="projectSideNav"] [data-test-subj~="sideNavMoreMenuItem"]`
}, {
  id: 'sidenav-manage-data',
  required: false,
  // tour will continue even if this step is not visible
  title: _i18n.i18n.translate('core.chrome.navigationTour.sidenavManageDataTitle', {
    defaultMessage: 'Data management now has its own menu'
  }),
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.chrome.navigationTour.sidenavDataManagementMessage",
    defaultMessage: "Ingest and data management features moved to their own menu and are now faster to access. Other administration options remain in the Stack management menu.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }))),
  target: `[data-test-subj~="projectSideNav"] [data-test-subj*="${_deeplinksManagement.DATA_MANAGEMENT_NAV_ID}"]`
}];