"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _lodash = require("lodash");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _controlsConstants = require("@kbn/controls-constants");
var _control_group_state_builder = require("../utils/control_group_state_builder");
var _serialization_utils = require("../utils/serialization_utils");
var _serialize_runtime_state = require("../utils/serialize_runtime_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/control_group_renderer/control_group_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlGroupRenderer = ({
  onApiAvailable,
  getCreationOptions,
  filters,
  timeRange,
  query,
  viewMode,
  dataLoading,
  compressed
}) => {
  const lastState$Ref = (0, _react.useRef)(new _rxjs.BehaviorSubject((0, _serialize_runtime_state.serializeRuntimeState)({})));
  const id = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);
  const [isStateLoaded, setIsStateLoaded] = (0, _react.useState)(false);
  const [controlGroup, setControlGroup] = (0, _react.useState)();

  /**
   * Parent API set up
   */
  const searchApi = (0, _presentationPublishing.useSearchApi)({
    filters,
    query,
    timeRange
  });
  const viewMode$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(viewMode !== null && viewMode !== void 0 ? viewMode : 'view'),
  // viewMode only used as initial value - changes do not effect memoized value.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => {
    if (viewMode) viewMode$.next(viewMode);
  }, [viewMode, viewMode$]);
  const dataLoading$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(Boolean(dataLoading)),
  // dataLoading only used as initial value - changes do not effect memoized value.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => {
    if (dataLoading !== dataLoading$.getValue()) dataLoading$.next(Boolean(dataLoading));
  }, [dataLoading, dataLoading$]);
  const reload$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  (0, _react.useEffect)(() => {
    if (!controlGroup) return;
    const subscription = controlGroup.hasUnsavedChanges$.subscribe(hasUnsavedChanges => {
      if (hasUnsavedChanges) lastState$Ref.current.next(controlGroup.serializeState());
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroup]);

  /**
   * On mount
   */
  (0, _react.useEffect)(() => {
    if (!getCreationOptions) {
      setIsStateLoaded(true);
      return;
    }
    let cancelled = false;
    getCreationOptions((0, _lodash.cloneDeep)(_serialize_runtime_state.defaultRuntimeState), _control_group_state_builder.controlGroupStateBuilder).then(({
      initialState,
      editorConfig
    }) => {
      if (cancelled) return;
      const initialRuntimeState = {
        ...(initialState !== null && initialState !== void 0 ? initialState : _serialize_runtime_state.defaultRuntimeState),
        editorConfig
      };
      lastState$Ref.current.next((0, _serialize_runtime_state.serializeRuntimeState)(initialRuntimeState));
      setIsStateLoaded(true);
    }).catch();
    return () => {
      cancelled = true;
    };
    // exhaustive deps disabled because we want the control group to be created only on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return !isStateLoaded ? null : /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    maybeId: id,
    type: _controlsConstants.CONTROLS_GROUP_TYPE,
    getParentApi: () => ({
      reload$,
      dataLoading$,
      viewMode$,
      query$: searchApi.query$,
      timeRange$: searchApi.timeRange$,
      unifiedSearchFilters$: searchApi.filters$,
      getSerializedStateForChild: () => lastState$Ref.current.value,
      lastSavedStateForChild$: () => lastState$Ref.current,
      getLastSavedStateForChild: () => lastState$Ref.current.value,
      compressed: compressed !== null && compressed !== void 0 ? compressed : true
    }),
    onApiAvailable: async controlGroupApi => {
      await controlGroupApi.untilInitialized();
      const controlGroupRendererApi = {
        ...controlGroupApi,
        reload: () => reload$.next(),
        updateInput: newInput => {
          lastState$Ref.current.next((0, _serialize_runtime_state.serializeRuntimeState)({
            ...lastState$Ref.current.value,
            ...newInput
          }));
          controlGroupApi.resetUnsavedChanges();
        },
        getInput$: () => lastState$Ref.current.pipe((0, _rxjs.map)(_serialization_utils.deserializeControlGroup)),
        getInput: () => (0, _serialization_utils.deserializeControlGroup)(lastState$Ref.current.value)
      };
      setControlGroup(controlGroupRendererApi);
      onApiAvailable(controlGroupRendererApi);
    },
    hidePanelChrome: true,
    panelProps: {
      hideLoader: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  });
};
exports.ControlGroupRenderer = ControlGroupRenderer;