"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _sortable = require("@dnd-kit/sortable");
var _utilities = require("@dnd-kit/utilities");
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _classnames = _interopRequireDefault(require("classnames"));
var _controlsConstants = require("@kbn/controls-constants");
var _floating_actions = require("./floating_actions");
var _control_error = require("./control_error");
var _control_panel = require("./control_panel.styles");
var _drag_handle = require("./drag_handle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/components/control_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlPanel = ({
  Component,
  uuid
}) => {
  var _api$parentApi, _api$parentApi2;
  const [api, setApi] = (0, _react.useState)(null);
  const {
    attributes,
    listeners,
    setNodeRef,
    transform,
    transition,
    isOver,
    isDragging,
    index,
    isSorting,
    activeIndex
  } = (0, _sortable.useSortable)({
    id: uuid
  });
  const viewModeSubject = (() => {
    if ((0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiHasParentApi)(api.parentApi) &&
    // api.parentApi => controlGroupApi
    (0, _presentationPublishing.apiPublishesViewMode)(api.parentApi.parentApi) // controlGroupApi.parentApi => dashboardApi
    ) return api.parentApi.parentApi.viewMode$; // get view mode from dashboard API
  })();
  const [dataLoading, blockingError, panelTitle, defaultPanelTitle, grow, width, labelPosition, disabledActionIds, rawViewMode] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api === null || api === void 0 ? void 0 : api.dataLoading$, api === null || api === void 0 ? void 0 : api.blockingError$, api === null || api === void 0 ? void 0 : api.title$, api === null || api === void 0 ? void 0 : api.defaultTitle$, api === null || api === void 0 ? void 0 : api.grow$, api === null || api === void 0 ? void 0 : api.width$, api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.labelPosition, api === null || api === void 0 ? void 0 : (_api$parentApi2 = api.parentApi) === null || _api$parentApi2 === void 0 ? void 0 : _api$parentApi2.disabledActionIds$, viewModeSubject);
  const isTwoLine = labelPosition === 'twoLine';
  const controlType = api ? api.type : undefined;
  const [initialLoadComplete, setInitialLoadComplete] = (0, _react.useState)(!dataLoading);
  if (!initialLoadComplete && (dataLoading === false || api && !api.dataLoading$)) {
    setInitialLoadComplete(true);
  }
  const viewMode = rawViewMode !== null && rawViewMode !== void 0 ? rawViewMode : 'view';
  const isEditable = viewMode === 'edit';
  const controlWidth = width !== null && width !== void 0 ? width : _controlsConstants.DEFAULT_CONTROL_WIDTH;
  const controlGrow = grow !== null && grow !== void 0 ? grow : _controlsConstants.DEFAULT_CONTROL_GROW;
  const controlLabel = isTwoLine ? panelTitle || defaultPanelTitle || '...' : undefined;
  const hasRoundedBorders = !(api !== null && api !== void 0 && api.CustomPrependComponent) && !isEditable && isTwoLine;
  const shouldHideComponent = Boolean(blockingError);
  const insertBefore = isOver && (index !== null && index !== void 0 ? index : -1) < (activeIndex !== null && activeIndex !== void 0 ? activeIndex : -1);
  const insertAfter = isOver && (index !== null && index !== void 0 ? index : -1) > (activeIndex !== null && activeIndex !== void 0 ? activeIndex : -1);
  const styles = (0, _use_memo_css.useMemoCss)(controlPanelStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "li",
    ref: setNodeRef,
    style: {
      transition,
      transform: isSorting ? undefined : _utilities.CSS.Translate.toString(transform)
    },
    grow: controlGrow,
    "data-control-id": uuid,
    "data-test-subj": "control-frame",
    "data-render-complete": "true",
    css: (0, _react2.css)([isDragging && styles.draggingItem, styles.controlWidthStyles]),
    className: (0, _classnames.default)({
      'controlFrameWrapper--medium': controlWidth === 'medium',
      'controlFrameWrapper--small': controlWidth === 'small',
      'controlFrameWrapper--large': controlWidth === 'large'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_floating_actions.FloatingActions, {
    "data-test-subj": "control-frame-floating-actions",
    api: api,
    isTwoLine: isTwoLine,
    viewMode: viewMode,
    disabledActions: disabledActionIds,
    isEnabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-frame-title",
    fullWidth: true,
    label: controlLabel,
    id: `control-title-${uuid}`,
    "aria-label": `Control for ${controlLabel}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    isLoading: Boolean(dataLoading),
    className: (0, _classnames.default)('controlFrame__formControlLayout', {
      'controlFrame__formControlLayout--twoLine': isTwoLine,
      'controlFrame__formControlLayout--edit': isEditable,
      'controlFrame_formControlAfter--insertBefore': insertBefore,
      'controlFrame_formControlAfter--insertAfter': insertAfter,
      controlType
    }),
    css: (0, _react2.css)(styles.formControl),
    prepend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_drag_handle.DragHandle, (0, _extends2.default)({
      isEditable: isEditable,
      controlTitle: panelTitle || defaultPanelTitle
    }, attributes, listeners, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    })), api !== null && api !== void 0 && api.CustomPrependComponent ? /*#__PURE__*/_react.default.createElement(api.CustomPrependComponent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 19
      }
    }) : isTwoLine ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: panelTitle || defaultPanelTitle,
      anchorProps: {
        css: styles.tooltipAnchor,
        className: 'eui-textTruncate'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "controlPanel--label",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 21
      }
    }, panelTitle || defaultPanelTitle))),
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, blockingError && /*#__PURE__*/_react.default.createElement(_control_error.ControlError, {
    error: blockingError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(Component, {
    className: "controlPanel",
    css: (0, _react2.css)([styles.containerBase, hasRoundedBorders && styles.containerRoundedBorders, shouldHideComponent && styles.containerHidden]),
    ref: newApi => {
      if (newApi && !api) setApi(newApi);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }))))));
};
exports.ControlPanel = ControlPanel;
const controlPanelStyles = {
  containerBase: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    maxInlineSize: '100% !important',
    height: euiTheme.size.xl,
    boxShadow: 'none !important',
    borderRadius: `0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium} 0 !important`
  }),
  containerRoundedBorders: ({
    euiTheme
  }) => (0, _react2.css)({
    borderRadius: `${euiTheme.border.radius.medium} !important`
  }),
  containerHidden: (0, _react2.css)({
    display: 'none' // Don't unmount, just hide
  }),
  formControl: ({
    euiTheme
  }) => (0, _react2.css)({
    '.euiFormControlLayout__prepend': {
      paddingLeft: 0,
      gap: 0,
      '&.timeSlider': {
        paddingInlineStart: `0 !important`
      },
      '.euiFormControlLayout__prepend': {
        // non-editable one line
        paddingInlineStart: `${euiTheme.size.s} !important`
      }
    },
    '&.controlFrame__formControlLayout--edit': {
      // editable one line
      '.euiFormControlLayout__prepend': {
        paddingInlineStart: `${euiTheme.size.xxs} !important` // corrected syntax for skinny icon
      }
    },
    '&.controlFrame__formControlLayout--twoLine': {
      // non-editable two lines
      '.euiFormControlLayout__prepend': {
        paddingInline: `0 !important`
      }
    },
    '&.controlFrame__formControlLayout--twoLine.controlFrame__formControlLayout--edit': {
      // editable two lines
      '.euiFormControlLayout__prepend': {
        paddingInlineStart: `0 !important`,
        paddingInlineEnd: `0 !important`
      }
    },
    '&.controlFrame_formControlAfter--insertBefore': {
      '&:after': {
        content: "''",
        position: 'absolute',
        borderRadius: euiTheme.border.radius.medium,
        top: 0,
        bottom: 0,
        width: euiTheme.size.xxs,
        backgroundColor: euiTheme.colors.backgroundFilledAccentSecondary,
        left: `calc(-${euiTheme.size.xs} - 1px)`
      }
    },
    '&.controlFrame_formControlAfter--insertAfter': {
      '&:after': {
        content: "''",
        position: 'absolute',
        borderRadius: euiTheme.border.radius.medium,
        top: 0,
        bottom: 0,
        width: euiTheme.size.xxs,
        backgroundColor: euiTheme.colors.backgroundFilledAccentSecondary,
        right: `calc(-${euiTheme.size.xs} - 1px)`
      }
    },
    '.controlPanel--label': {
      padding: '0 !important',
      height: '100%',
      maxWidth: '100%'
    }
  }),
  tooltipAnchor: (0, _react2.css)({
    height: '100%'
  }),
  draggingItem: (0, _react2.css)({
    opacity: 0
  }),
  controlWidthStyles: _control_panel.controlWidthStyles
};