"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _reactHooks = require("@kbn/react-hooks");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/components/control_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultMessage = _i18n.i18n.translate('controls.blockingError', {
  defaultMessage: 'There was an error loading this control.'
});
const controlErrorStyles = {
  button: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    height: euiTheme.size.xl,
    borderRadius: `0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium} 0 !important`
  }),
  buttonContentCss: ({
    euiTheme
  }) => (0, _react2.css)({
    justifyContent: 'left',
    paddingLeft: euiTheme.size.m
  }),
  popover: ({
    euiTheme
  }) => (0, _react2.css)({
    width: '100%',
    maxInlineSize: '100% !important',
    height: euiTheme.size.xl,
    boxShadow: 'none !important',
    borderRadius: `0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium} 0 !important`
  })
};
const ControlError = ({
  error
}) => {
  const errorTextStyle = (0, _reactHooks.useErrorTextStyle)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const errorMessage = error instanceof Error ? error.message : error || defaultMessage;
  const styles = (0, _use_memo_css.useMemoCss)(controlErrorStyles);
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    color: "danger",
    iconSize: "m",
    iconType: "error",
    "data-test-subj": "control-frame-error",
    onClick: () => setPopoverOpen(open => !open),
    className: "controlErrorButton",
    css: styles.button,
    contentProps: {
      css: styles.buttonContentCss
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "controls.frame.error.message",
    defaultMessage: "An error occurred. View more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverOpen(false),
    css: styles.popover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    "data-test-subj": "errorMessageMarkdown",
    readOnly: true,
    css: errorTextStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, errorMessage));
};
exports.ControlError = ControlError;