"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSync = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _error_codes = require("../../../common/types/error_codes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startSync = async (client, connectorId, jobType) => {
  const connector = await (0, _searchConnectors.fetchConnectorById)(client.asCurrentUser, connectorId);
  if (connector) {
    var _configuration$use_do;
    const configuration = Object.entries(connector.configuration).reduce((acc, [key, configEntry]) => {
      if ((0, _searchConnectors.isConfigEntry)(configEntry)) {
        acc[key] = configEntry;
      }
      return acc;
    }, {});
    if (jobType === _searchConnectors.SyncJobType.ACCESS_CONTROL && !((_configuration$use_do = configuration.use_document_level_security) !== null && _configuration$use_do !== void 0 && _configuration$use_do.value)) {
      throw new Error(_error_codes.ErrorCode.ACCESS_CONTROL_DISABLED);
    }
    return await (0, _searchConnectors.startConnectorSync)(client.asCurrentUser, {
      connectorId,
      jobType
    });
  } else {
    throw new Error(_error_codes.ErrorCode.RESOURCE_NOT_FOUND);
  }
};
exports.startSync = startSync;