"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/connector_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorField = ({
  connector,
  field,
  isTitle
}) => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const [value, setValue] = (0, _react.useState)(connector[field]);
  const [resolverObject, setResolverObject] = (0, _react.useState)({
    rej: () => {},
    res: () => {}
  });
  const {
    saveNameAndDescription,
    setConnector
  } = (0, _kea.useActions)((0, _connector_name_and_description_logic.ConnectorNameAndDescriptionLogic)({
    http
  }));
  const {
    status,
    isLoading,
    isFailed,
    isSuccess
  } = (0, _kea.useValues)((0, _connector_name_and_description_logic.ConnectorNameAndDescriptionLogic)({
    http
  }));
  (0, _react.useEffect)(() => {
    setConnector(connector);
  }, [connector, setConnector]);
  (0, _react.useEffect)(() => {
    if (isSuccess) resolverObject.res();
    if (isFailed) resolverObject.rej();
  }, [isFailed, isSuccess, resolverObject, status]);
  const getValidationPromiseResolvers = () => {
    const resolvers = {
      rej: () => {},
      res: () => {}
    };
    const promise = new Promise((resolve, reject) => {
      resolvers.res = resolve;
      resolvers.rej = reject;
    });
    setResolverObject(resolvers);
    return promise;
  };
  const handleSave = async newValue => {
    setValue(newValue);
    saveNameAndDescription({
      ...connector,
      [field]: newValue
    });
    await getValidationPromiseResolvers();
    return true;
  };
  const handleCancel = previousValue => {
    setValue(previousValue);
  };
  const Component = isTitle ? _eui.EuiInlineEditTitle : _eui.EuiInlineEditText;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Component, {
    inputAriaLabel: _i18n.i18n.translate(`xpack.contentConnectors.connectors.nameAndDescription.${field}.ariaLabel`, {
      defaultMessage: `Edit connector ${field}`
    }),
    placeholder: _i18n.i18n.translate(`xpack.contentConnectors.connectors.nameAndDescription.${field}.placeholder`, {
      defaultMessage: field === 'name' ? 'Add a name to your connector' : 'Add a description'
    }),
    value: value || '',
    isLoading: isLoading,
    isInvalid: field === 'name' && !(value !== null && value !== void 0 && value.trim()),
    size: "m",
    heading: isTitle ? 'h1' : 'span',
    editModeProps: {
      cancelButtonProps: {
        onClick: () => handleCancel(connector[field] || '')
      },
      formRowProps: field === 'name' && !(value !== null && value !== void 0 && value.trim()) ? {
        error: [_i18n.i18n.translate('xpack.contentConnectors.nameAndDescription.name.error.empty', {
          defaultMessage: 'Connector name cannot be empty'
        })]
      } : undefined,
      inputProps: {
        readOnly: isLoading
      }
    },
    onSave: handleSave,
    onChange: e => setValue(e.target.value),
    onCancel: () => handleCancel(connector[field] || ''),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};
exports.ConnectorField = ConnectorField;