"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LanguageSelectorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/editor/components/context_menu/language_selector_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  constrainedSelectable: (0, _react2.css)`
    max-width: 550px;
  `
};
const DEFAULT_BADGE = /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 5
  }
}, _i18n.i18n.translate('console.requestPanel.contextMenu.defaultSelectedLanguage', {
  defaultMessage: 'Default'
})));
const LanguageSelectorModal = ({
  closeModal,
  onSubmit,
  currentLanguage,
  changeDefaultLanguage
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(currentLanguage);
  const [options, setOptions] = (0, _react.useState)(_constants.AVAILABLE_LANGUAGES.map(lang => ({
    label: lang.label,
    key: lang.value,
    'data-test-subj': `languageOption-${lang.value}`
  })));
  const noOptionsSelected = options.every(option => !option.checked);
  const optionsList = (0, _react.useMemo)(() => {
    return options.map(option => ({
      ...option,
      ...(noOptionsSelected && option.key === selectedLanguage && {
        checked: 'on'
      }),
      append: option.key === selectedLanguage ? DEFAULT_BADGE : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setSelectedLanguage(option.key),
        "data-test-subj": `changeDefaultLanguageTo-${option.key}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('console.requestPanel.contextMenu.defaultSelectedLanguage', {
        defaultMessage: 'Set as default'
      }))
    }));
  }, [options, selectedLanguage, noOptionsSelected]);
  const onCopyCode = () => {
    const selectedOption = options.find(option => option.checked);
    const language = (selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.key) || selectedLanguage;

    // If the default language is changed, update the local storage setting
    if (currentLanguage !== selectedLanguage) {
      changeDefaultLanguage(selectedLanguage);
    }
    onSubmit(language);
  };
  const onCloseModal = () => {
    changeDefaultLanguage(selectedLanguage);
    closeModal();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onCloseModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.requestPanel.contextMenu.languageSelectorModalTitle",
    defaultMessage: "Select a language",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    css: styles.constrainedSelectable,
    options: optionsList,
    onChange: changedOptions => setOptions(changedOptions),
    singleSelection: "always",
    listProps: {
      onFocusBadge: false,
      isVirtualized: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, list => list)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCloseModal,
    "data-test-subj": "closeCopyAsModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.requestPanel.contextMenu.languageSelectorModalCancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCopyCode,
    fill: true,
    "data-test-subj": "copyAsLanguageSubmit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.requestPanel.contextMenu.languageSelectorModalCopy",
    defaultMessage: "Copy code",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }))));
};
exports.LanguageSelectorModal = LanguageSelectorModal;