"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _kibana = require("../../../common/lib/kibana");
var _use_get_choices = require("./use_get_choices");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _deprecated_callout = require("../deprecated_callout");
var _validate_json = require("../validate_json");
var _json_editor_field = require("../json_editor_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/servicenow/servicenow_sir_case_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const choicesToGet = ['category', 'subcategory', 'priority'];
const defaultFields = {
  category: [],
  subcategory: [],
  priority: []
};
const validateJSON = (0, _validate_json.generateJSONValidator)();
const ServiceNowSIRFieldsComponent = ({
  connector
}) => {
  var _choicesData$data;
  const form = (0, _hook_form_lib.useFormContext)();
  const [{
    fields
  }] = (0, _hook_form_lib.useFormData)();
  const {
    category = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const showConnectorWarning = connector.isDeprecated;
  const {
    isLoading,
    isFetching,
    data: choicesData
  } = (0, _use_get_choices.useGetChoices)({
    http,
    connector,
    fields: choicesToGet
  });
  const choices = (_choicesData$data = choicesData === null || choicesData === void 0 ? void 0 : choicesData.data) !== null && _choicesData$data !== void 0 ? _choicesData$data : [];
  const isLoadingChoices = isLoading || isFetching;
  const choicesFormatted = choices.reduce((acc, value) => ({
    ...acc,
    [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
  }), defaultFields);
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.category), [choicesFormatted.category]);
  const priorityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.priority), [choicesFormatted.priority]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.subcategory.filter(choice => choice.dependent_value === category)), [choicesFormatted.subcategory, category]);
  const onCategoryChange = () => {
    form.setFieldValue('fields.subcategory', null);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConnectorWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "connector-fields-sn-sir",
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.ALERT_FIELDS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.destIp",
    config: {
      defaultValue: true
    },
    component: _components.CheckBoxField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'destIpCheckbox',
        label: i18n.DEST_IP,
        compressed: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.sourceIp",
    config: {
      defaultValue: true
    },
    component: _components.CheckBoxField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'sourceIpCheckbox',
        label: i18n.SOURCE_IP,
        compressed: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.malwareUrl",
    config: {
      defaultValue: true
    },
    component: _components.CheckBoxField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'malwareUrlCheckbox',
        label: i18n.MALWARE_URL,
        compressed: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.malwareHash",
    config: {
      defaultValue: true
    },
    component: _components.CheckBoxField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'malwareHashCheckbox',
        label: i18n.MALWARE_HASH,
        compressed: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.priority",
    component: _components.SelectField,
    config: {
      label: i18n.PRIORITY
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'prioritySelect',
        options: priorityOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.category",
    component: _components.SelectField,
    config: {
      label: i18n.CATEGORY
    },
    onChange: onCategoryChange,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'categorySelect',
        options: categoryOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.subcategory",
    component: _components.SelectField,
    config: {
      label: i18n.SUBCATEGORY
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'subcategorySelect',
        options: subcategoryOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.additionalFields",
    component: _json_editor_field.JsonEditorField,
    config: {
      label: i18n.ADDITIONAL_FIELDS_LABEL,
      validations: [{
        validator: validateJSON
      }]
    },
    componentProps: {
      euiCodeEditorProps: {
        fullWidth: true,
        height: '200px',
        options: {
          fontSize: '12px',
          renderValidationDecorations: 'off'
        }
      },
      dataTestSubj: 'additionalFieldsEditor'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  })))));
};
exports.default = ServiceNowSIRFieldsComponent;
ServiceNowSIRFieldsComponent.displayName = 'ServiceNowSIRFieldsComponent';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;