"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewMetricItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _api = require("../../../../common/types/api");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/metrics/totals.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseViewMetricItems = exports.CaseViewMetricItems = /*#__PURE__*/_react.default.memo(({
  metrics,
  features
}) => {
  const metricItems = useGetTitleValueMetricItems(metrics, features);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metricItems.map(({
    id,
    title,
    value
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: title,
    "data-test-subj": `case-metrics-totals-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 15
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                  font-size: ${euiTheme.size.l};
                  font-weight: bold;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 15
    }
  }, value)))));
});
CaseViewMetricItems.displayName = 'CaseViewMetricItems';
const useGetTitleValueMetricItems = (metrics, features) => {
  var _connectors$total, _alerts$count, _alerts$users$total, _alerts$users, _alerts$hosts$total, _alerts$hosts;
  const {
    alerts,
    actions,
    connectors
  } = metrics !== null && metrics !== void 0 ? metrics : {};
  const totalConnectors = (_connectors$total = connectors === null || connectors === void 0 ? void 0 : connectors.total) !== null && _connectors$total !== void 0 ? _connectors$total : 0;
  const alertsCount = (_alerts$count = alerts === null || alerts === void 0 ? void 0 : alerts.count) !== null && _alerts$count !== void 0 ? _alerts$count : 0;
  const totalAlertUsers = (_alerts$users$total = alerts === null || alerts === void 0 ? void 0 : (_alerts$users = alerts.users) === null || _alerts$users === void 0 ? void 0 : _alerts$users.total) !== null && _alerts$users$total !== void 0 ? _alerts$users$total : 0;
  const totalAlertHosts = (_alerts$hosts$total = alerts === null || alerts === void 0 ? void 0 : (_alerts$hosts = alerts.hosts) === null || _alerts$hosts === void 0 ? void 0 : _alerts$hosts.total) !== null && _alerts$hosts$total !== void 0 ? _alerts$hosts$total : 0;
  const totalIsolatedHosts = calculateTotalIsolatedHosts(actions);
  const metricItems = (0, _react.useMemo)(() => {
    const items = [[_api.CaseMetricsFeature.ALERTS_COUNT, {
      title: _translations.TOTAL_ALERTS_METRIC,
      value: alertsCount
    }], [_api.CaseMetricsFeature.ALERTS_USERS, {
      title: _translations.ASSOCIATED_USERS_METRIC,
      value: totalAlertUsers
    }], [_api.CaseMetricsFeature.ALERTS_HOSTS, {
      title: _translations.ASSOCIATED_HOSTS_METRIC,
      value: totalAlertHosts
    }], [_api.CaseMetricsFeature.ACTIONS_ISOLATE_HOST, {
      title: _translations.ISOLATED_HOSTS_METRIC,
      value: totalIsolatedHosts
    }], [_api.CaseMetricsFeature.CONNECTORS, {
      title: _translations.TOTAL_CONNECTORS_METRIC,
      value: totalConnectors
    }]];
    return items.reduce((result, [feature, item]) => [...result, ...(features.includes(feature) ? [{
      id: feature,
      ...item
    }] : [])], []);
  }, [features, alertsCount, totalAlertUsers, totalAlertHosts, totalIsolatedHosts, totalConnectors]);
  return metricItems;
};
const calculateTotalIsolatedHosts = actions => {
  if (!(actions !== null && actions !== void 0 && actions.isolateHost)) {
    return 0;
  }

  // prevent the metric from being negative
  return Math.max(actions.isolateHost.isolate.total - actions.isolateHost.unisolate.total, 0);
};