"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditCategory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _use_get_categories = require("../../../containers/use_get_categories");
var i18n = _interopRequireWildcard(require("../../category/translations"));
var _category_viewer_component = require("../../category/category_viewer_component");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _category_form_field = require("../../category/category_form_field");
var _removable_item = require("../../removable_item/removable_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/edit_category.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategoryFormWrapper = ({
  category,
  availableCategories,
  isLoading,
  onChange
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      category
    }
  });
  const {
    submit,
    isValid: isFormValid
  } = form;
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid: isFormValid,
        submit
      });
    }
  }, [isFormValid, onChange, submit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_category_form_field.CategoryFormField, {
    isLoading: isLoading,
    availableCategories: availableCategories,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
CategoryFormWrapper.displayName = 'CategoryFormWrapper';
const EditCategory = exports.EditCategory = /*#__PURE__*/_react.default.memo(({
  isLoading,
  onSubmit,
  category
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isEditCategory, setIsEditCategory] = (0, _react.useState)(false);
  const {
    data: categories = [],
    isLoading: isLoadingCategories
  } = (0, _use_get_categories.useGetCategories)();
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    })
  });
  const onEdit = () => {
    setIsEditCategory(true);
  };
  const onCancel = () => {
    setIsEditCategory(false);
  };
  const removeCategory = () => {
    onSubmit(null);
    setIsEditCategory(false);
  };
  const onSubmitCategory = async () => {
    const {
      isValid,
      data
    } = await formState.submit();
    if (isValid) {
      var _data$category$trim, _data$category;
      onSubmit((_data$category$trim = (_data$category = data.category) === null || _data$category === void 0 ? void 0 : _data$category.trim()) !== null && _data$category$trim !== void 0 ? _data$category$trim : null);
    }
    setIsEditCategory(false);
  };
  const isLoadingAll = isLoading || isLoadingCategories;
  const isCategoryValid = formState.isValid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false,
    "data-test-subj": "cases-categories",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, i18n.CATEGORY))), isLoadingAll && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "category-loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 26
    }
  }), !isLoadingAll && permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "category-edit-button",
    "aria-label": i18n.EDIT_CATEGORIES_ARIA,
    iconType: 'pencil',
    onClick: onEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "case-category",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, !isEditCategory && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, category ? /*#__PURE__*/_react.default.createElement(_removable_item.RemovableItem, {
    onRemoveItem: removeCategory,
    tooltipContent: i18n.REMOVE_CATEGORY,
    buttonAriaLabel: i18n.REMOVE_CATEGORY_ARIA_LABEL,
    dataTestSubjPrefix: "category",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_category_viewer_component.CategoryViewer, {
    category: category,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "no-categories",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, i18n.NO_CATEGORIES)), isEditCategory && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "edit-category",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CategoryFormWrapper, {
    onChange: setFormState,
    category: category,
    availableCategories: categories,
    isLoading: isLoadingAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "edit-category-submit",
    fill: true,
    iconType: "save",
    onClick: onSubmitCategory,
    size: "s",
    disabled: !isCategoryValid || isLoadingAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 19
    }
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-category-cancel",
    iconType: "cross",
    onClick: onCancel,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 19
    }
  }, i18n.CANCEL)))))));
});
EditCategory.displayName = 'EditCategory';