"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _builder = require("../../custom_fields/builder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/custom_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomFieldsComponent = ({
  isLoading,
  customFields,
  customFieldsConfiguration,
  onSubmit
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const sortedCustomFieldsConfiguration = (0, _react.useMemo)(() => sortCustomFieldsByLabel(customFieldsConfiguration), [customFieldsConfiguration]);
  const onSubmitCustomField = (0, _react.useCallback)(customFieldToAdd => {
    onSubmit(customFieldToAdd);
  }, [onSubmit]);
  const customFieldsComponents = sortedCustomFieldsConfiguration.map(customFieldConf => {
    const customFieldFactory = _builder.builderMap[customFieldConf.type];
    const customFieldType = customFieldFactory().build();
    const customField = customFields.find(field => field.key === customFieldConf.key);
    const EditComponent = customFieldType.Edit;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": `case-custom-field-wrapper-${customFieldConf.key}`,
      key: customFieldConf.key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(EditComponent, {
      isLoading: isLoading,
      canUpdate: permissions.update,
      customFieldConfiguration: customFieldConf,
      customField: customField,
      onSubmit: onSubmitCustomField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, customFieldsComponents);
};
CustomFieldsComponent.displayName = 'CustomFields';
const CustomFields = exports.CustomFields = /*#__PURE__*/_react.default.memo(CustomFieldsComponent);
const sortCustomFieldsByLabel = customFieldsConfiguration => {
  return (0, _lodash.sortBy)(customFieldsConfiguration, customFieldConf => {
    return customFieldConf.label;
  });
};