"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllCasesSelectorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _all_cases_list = require("../all_cases_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/selector_modal/all_cases_selector_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AllCasesSelectorModal = exports.AllCasesSelectorModal = /*#__PURE__*/_react.default.memo(({
  hiddenStatuses,
  onRowClick,
  onClose,
  getAttachments
}) => {
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(true);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const closeModal = (0, _react.useCallback)(() => {
    onClose === null || onClose === void 0 ? void 0 : onClose();
    setIsModalOpen(false);
  }, [onClose]);
  const onClick = (0, _react.useCallback)((theCase, isCreateCase) => {
    onClose === null || onClose === void 0 ? void 0 : onClose(theCase, isCreateCase);
    setIsModalOpen(false);
    onRowClick === null || onRowClick === void 0 ? void 0 : onRowClick(theCase);
  }, [onClose, onRowClick]);
  return isModalOpen ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": "all-cases-modal-title",
    onClose: closeModal,
    "data-test-subj": "all-cases-modal",
    css: (0, _react2.css)`
            min-width: ${euiTheme.breakpoint.m}px;
            max-width: ${euiTheme.breakpoint.xl}px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: "all-cases-modal-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, i18n.SELECT_CASE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_all_cases_list.AllCasesList, {
    hiddenStatuses: hiddenStatuses,
    isSelectorView: true,
    onRowClick: onClick,
    getAttachments: getAttachments,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: closeModal,
    "data-test-subj": "all-cases-modal-cancel-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, i18n.CANCEL)))) : null;
});
AllCasesSelectorModal.displayName = 'AllCasesSelectorModal';