"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BorderForm = void 0;
Object.defineProperty(exports, "BorderStyle", {
  enumerable: true,
  get: function () {
    return _types.BorderStyle;
  }
});
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _color_picker_popover = require("../../../components/color_picker_popover");
var _types = require("../../../../types");
var _i18n = require("../../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/expression_types/arg_types/container_style/border_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  ContainerStyle: strings
} = _i18n.ArgTypesStrings;
const BorderForm = ({
  value = '',
  radius = '',
  onChange,
  colors
}) => {
  const [borderWidth = '', borderStyle = '', borderColor = ''] = value.split(' ');
  const borderStyleVal = (0, _types.isBorderStyle)(borderStyle) ? borderStyle : _types.BorderStyle.NONE;
  const borderWidthVal = borderWidth ? borderWidth.replace('px', '') : '';
  const radiusVal = typeof radius === 'string' ? radius.replace('px', '') : radius;
  const namedChange = name => val => {
    if (name === 'borderWidth') {
      return onChange('border', `${val}px ${borderStyle} ${borderColor}`);
    }
    if (name === 'borderStyle') {
      if (val === '') {
        return onChange('border', `0px`);
      }
      return onChange('border', `${borderWidth} ${val} ${borderColor}`);
    }
    if (name === 'borderRadius') {
      if (val === '') {
        return onChange('borderRadius', `0px`);
      }
      return onChange('borderRadius', `${val}px`);
    }
    onChange(name, val);
  };
  const borderColorChange = color => onChange('border', `${borderWidth} ${borderStyle} ${color}`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getThicknessLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: Number(borderWidthVal),
    onChange: e => namedChange('borderWidth')(Number(e.target.value)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getStyleLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    valueOfSelected: borderStyleVal || 'none',
    options: Object.values(_types.BorderStyle).map(style => ({
      value: style,
      inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
        style: {
          height: 16,
          border: `4px ${style}`
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 29
        }
      })
    })),
    onChange: namedChange('borderStyle'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getRadiusLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: Number(radiusVal),
    onChange: e => namedChange('borderRadius')(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: strings.getColorLabel(),
    style: {
      fontSize: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_color_picker_popover.ColorPickerPopover, {
    value: borderColor,
    onChange: borderColorChange,
    colors: colors,
    anchorPosition: "upCenter",
    ariaLabel: strings.getBorderTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }))));
};
exports.BorderForm = BorderForm;
BorderForm.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  value: _propTypes.default.string,
  // @ts-expect-error upgrade typescript v5.9.3
  radius: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  onChange: _propTypes.default.func.isRequired,
  colors: _propTypes.default.array.isRequired
};