"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ErrorComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/error/components/error_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Error = (0, _public.withSuspense)(_.LazyErrorComponent);
function ErrorComponent({
  onLoaded,
  parentNode,
  error
}) {
  const getButtonSize = node => Math.min(node.clientHeight, node.clientWidth);
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [buttonSize, setButtonSize] = (0, _react.useState)(getButtonSize(parentNode));
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const handlePopoverClick = () => setPopoverOpen(!isPopoverOpen);
  const closePopover = () => setPopoverOpen(false);
  const updateErrorView = (0, _react.useCallback)(() => {
    setButtonSize(getButtonSize(parentNode));
    onLoaded();
  }, [parentNode, onLoaded]);
  (0, _react.useEffect)(() => {
    updateErrorView();
  }, [parentNodeDimensions, updateErrorView]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasRenderError",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "canvasRenderError__icon",
      onClick: handlePopoverClick,
      style: {
        height: buttonSize,
        width: buttonSize
      },
      type: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }),
    isOpen: isPopoverOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Error, {
    payload: {
      error
    },
    onClose: closePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;