"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceMapLink = ServiceMapLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/apm/service_map_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServiceMapLink({
  serviceName,
  query,
  ...rest
}) {
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const href = serviceName ? link('/services/{serviceName}/service-map', {
    path: {
      serviceName
    },
    query
  }) : link('/service-map', {
    query
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmServiceMapLinkLink",
    href: href
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 10
    }
  }));
}