"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWithOffset = RedirectWithOffset;
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _react = _interopRequireDefault(require("react"));
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _is_route_with_time_range = require("../../../shared/is_route_with_time_range");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _helpers = require("../../../../context/url_params_context/helpers");
var _redirect_to = require("../../redirect_to");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/app_root/redirect_with_offset/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RedirectWithOffset({
  children
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const matchesRoute = (0, _is_route_with_time_range.isRouteWithComparison)({
    apmRouter,
    location
  });
  const query = _queryString.default.parse(location.search);

  // Redirect when 'comparisonType' is set as we now use offset instead
  // or when 'comparisonEnabled' is not set as it's now required
  if (matchesRoute && ('comparisonType' in query || !('comparisonEnabled' in query))) {
    const {
      comparisonType,
      comparisonEnabled: urlComparisonEnabled,
      ...queryRest
    } = query;
    const comparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
      core,
      urlComparisonEnabled: urlComparisonEnabled ? (0, _helpers.toBoolean)(urlComparisonEnabled) : undefined
    }).toString();
    const comparisonTypeEnumValue = comparisonType;
    const dayOrWeekOffset = _get_comparison_options.dayAndWeekBeforeToOffset[comparisonTypeEnumValue];
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RenderRedirectTo, {
      location: {
        ...location,
        search: _queryString.default.stringify({
          ...queryRest,
          comparisonEnabled,
          ...(dayOrWeekOffset ? {
            offset: dayOrWeekOffset
          } : {})
        })
      },
      pathname: location.pathname,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    });
  }
  return children;
}