"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Introduction = Introduction;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/introduction.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Introduction({
  isBeta,
  guideLink
}) {
  const betaBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.apm.onboarding.betaLabel', {
      defaultMessage: 'Beta'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
  const previewImage = (0, _use_kibana_url.useKibanaUrl)('/plugins/apm/assets/apm.png');
  const rightSideItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "l",
    allowFullScreen: true,
    fullScreenIconColor: "dark",
    alt: _i18n.i18n.translate('xpack.apm.onboarding.introduction.imageAltDescription', {
      defaultMessage: 'screenshot of primary dashboard.'
    }),
    url: previewImage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  })];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    iconType: "apmApp",
    pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.onboarding.appName', {
      defaultMessage: 'APM'
    }), isBeta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", betaBadge)),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.onboarding.specProvider.longDescription",
      defaultMessage: "Application Performance Monitoring (APM) collects in-depth performance metrics and errors from inside your application. It allows you to monitor the performance of thousands of applications in real time. {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmIntroductionLearnMoreLink",
          href: guideLink,
          "aria-label": _i18n.i18n.translate('xpack.apm.onboarding.specProvider.learnMoreAriaLabel', {
            defaultMessage: 'Learn more about APM'
          }),
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.apm.onboarding.specProvider.learnMoreLabel', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    })),
    rightSideItems: rightSideItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
}