"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyCallout = ApiKeyCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/instructions/api_key_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApiKeyCallout({
  isSuccess,
  isError,
  errorMessage
}) {
  if (isSuccess) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.apm.onboarding.apiKey.success.calloutTitle', {
        defaultMessage: 'API key created'
      }),
      color: "success",
      iconType: "check",
      "data-test-subj": "apiKeySuccessCallout",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.apiKey.success.calloutMessage', {
      defaultMessage: `Remember to store this information in a safe place. It won't be displayed anymore after you continue`
    })));
  }
  const regex = /missing the following requested privilege\(s\)/;
  const isInsufficientPermissionsError = isError && regex.test(errorMessage || '');
  if (isInsufficientPermissionsError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.apm.onboarding.apiKey.warning.calloutTitle', {
        defaultMessage: 'User does not have permissions to create API Key'
      }),
      color: "warning",
      iconType: "warning",
      "data-test-subj": "apiKeyWarningCallout",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.apiKey.warning.calloutMessage', {
      defaultMessage: 'User is missing the following privilege - {missingPrivilege}. Please add the missing APM application privilege to the role of the authenticated user',
      values: {
        missingPrivilege: 'event:write'
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.apiKey.error.calloutTitle', {
      defaultMessage: 'Failed to create API key'
    }),
    color: "danger",
    iconType: "error",
    "data-test-subj": "apiKeyErrorCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.onboarding.apiKey.error.calloutMessage', {
    defaultMessage: 'Error: {errorMessage}',
    values: {
      errorMessage
    }
  }));
}