"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDurationRuleType = TransactionDurationRuleType;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _helper = require("../../../shared/charts/transaction_charts/helper");
var _chart_preview = require("../../ui_components/chart_preview");
var _fields = require("../../utils/fields");
var _helper2 = require("../../utils/helper");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _popover_expression = require("../../ui_components/popover_expression");
var _apm_rule_group_by = require("../../ui_components/apm_rule_group_by");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_preview_helper = require("../../ui_components/chart_preview/chart_preview_helper");
var _apm_rule_kql_filter = require("../../ui_components/apm_rule_kql_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/rule_types/transaction_duration_rule_type/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TRANSACTION_ALERT_AGGREGATION_TYPES = {
  [_apm_rule_types.AggregationType.Avg]: _i18n.i18n.translate('xpack.apm.transactionDurationAlert.aggregationType.avg', {
    defaultMessage: 'Average'
  }),
  [_apm_rule_types.AggregationType.P95]: _i18n.i18n.translate('xpack.apm.transactionDurationAlert.aggregationType.95th', {
    defaultMessage: '95th percentile'
  }),
  [_apm_rule_types.AggregationType.P99]: _i18n.i18n.translate('xpack.apm.transactionDurationAlert.aggregationType.99th', {
    defaultMessage: '99th percentile'
  })
};
function TransactionDurationRuleType(props) {
  var _latencyChartPreview$, _latencyChartPreview$2;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    aggregationType: _apm_rule_types.AggregationType.Avg,
    threshold: 1500,
    windowSize: 5,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const {
      interval,
      start,
      end
    } = (0, _helper2.getIntervalAndTimeRange)({
      windowSize: params.windowSize,
      windowUnit: params.windowUnit
    });
    if (params.windowSize && start && end) {
      var _params$searchConfigu, _params$searchConfigu2;
      return callApmApi('GET /internal/apm/rule_types/transaction_duration/chart_preview', {
        params: {
          query: {
            aggregationType: params.aggregationType,
            environment: params.environment,
            serviceName: params.serviceName,
            transactionType: params.transactionType,
            transactionName: params.transactionName,
            interval,
            start,
            end,
            groupBy: params.groupBy,
            searchConfiguration: (_params$searchConfigu = params.searchConfiguration) !== null && _params$searchConfigu !== void 0 && (_params$searchConfigu2 = _params$searchConfigu.query) !== null && _params$searchConfigu2 !== void 0 && _params$searchConfigu2.query ? JSON.stringify(params.searchConfiguration) : undefined
          }
        }
      });
    }
  }, [params.aggregationType, params.environment, params.serviceName, params.transactionType, params.transactionName, params.windowSize, params.windowUnit, params.groupBy, params.searchConfiguration]);
  const latencyChartPreview = data === null || data === void 0 ? void 0 : data.latencyChartPreview;
  const series = (_latencyChartPreview$ = latencyChartPreview === null || latencyChartPreview === void 0 ? void 0 : latencyChartPreview.series) !== null && _latencyChartPreview$ !== void 0 ? _latencyChartPreview$ : [];
  const hasData = series.length > 0;
  const totalGroups = (_latencyChartPreview$2 = latencyChartPreview === null || latencyChartPreview === void 0 ? void 0 : latencyChartPreview.totalGroups) !== null && _latencyChartPreview$2 !== void 0 ? _latencyChartPreview$2 : 0;
  const maxY = (0, _helper.getMaxY)(series);
  const formatter = (0, _formatters.getDurationFormatter)(maxY);
  const yTickFormat = (0, _helper.getResponseTimeTickFormatter)(formatter);

  // The threshold from the form is in ms. Convert to µs.
  const thresholdMs = params.threshold * 1000;
  const chartPreview = (0, _use_fetcher.isPending)(status) ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.LoadingState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }) : !hasData ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.NoDataState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }) : status === _use_fetcher.FETCH_STATUS.SUCCESS ? /*#__PURE__*/_react.default.createElement(_chart_preview.ChartPreview, {
    series: series,
    threshold: thresholdMs,
    yTickFormat: yTickFormat,
    uiSettings: services.uiSettings,
    timeSize: params.windowSize,
    timeUnit: params.windowUnit,
    totalGroups: totalGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_chart_preview_helper.ErrorState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  });
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group !== null && group !== void 0 ? group : []);
  }, [setRuleParams]);
  const filterFields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    allowAll: false,
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('transactionType', undefined);
        setRuleParams('transactionName', undefined);
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionTypeField, {
    currentValue: params.transactionType,
    onChange: value => setRuleParams('transactionType', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value !== '' ? value : _environment_filter_values.ENVIRONMENT_ALL.value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionNameField, {
    currentValue: params.transactionName,
    onChange: value => setRuleParams('transactionName', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  })];
  const criteriaFields = [/*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: params.aggregationType,
    title: _i18n.i18n.translate('xpack.apm.transactionDurationRuleType.when', {
      defaultMessage: 'When'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.apm.transactionDurationRuleType.aggregationTypeSelect.ariaLabel', {
      defaultMessage: 'Aggregation type'
    }),
    "data-test-subj": "apmTransactionDurationRuleTypeSelect",
    value: params.aggregationType,
    options: (0, _lodash.map)(TRANSACTION_ALERT_AGGREGATION_TYPES, (label, key) => {
      return {
        text: label,
        value: key
      };
    }),
    onChange: e => setRuleParams('aggregationType', e.target.value),
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_fields.IsAboveField, {
    value: params.threshold,
    unit: _i18n.i18n.translate('xpack.apm.transactionDurationRuleType.ms', {
      defaultMessage: 'ms'
    }),
    onChange: value => setRuleParams('threshold', value || 0),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    onChangeWindowSize: timeWindowSize => setRuleParams('windowSize', timeWindowSize || ''),
    onChangeWindowUnit: timeWindowUnit => setRuleParams('windowUnit', timeWindowUnit),
    timeWindowSize: params.windowSize,
    timeWindowUnit: params.windowUnit,
    errors: {
      timeWindowSize: [],
      timeWindowUnit: []
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 5
    }
  })];
  const fields = [...(!ruleParams.useKqlFilter ? filterFields : []), ...criteriaFields];
  const groupAlertsBy = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.ruleFlyout.transactionDuration.createAlertPerText', {
      defaultMessage: 'Group alerts by'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.ruleFlyout.transactionDuration.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "transaction.name". By default, alert is created for every unique service.name, service.environment and transaction.type.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_rule_group_by.APMRuleGroupBy, {
    onChange: onGroupByChange,
    options: {
      groupBy: ruleParams.groupBy
    },
    fields: [_apm.TRANSACTION_NAME],
    preSelectedOptions: [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT, _apm.TRANSACTION_TYPE],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }));
  const onToggleKqlFilter = e => {
    setRuleParams('serviceName', undefined);
    setRuleParams('transactionType', undefined);
    setRuleParams('transactionName', undefined);
    setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
    setRuleParams('searchConfiguration', {
      query: {
        query: '',
        language: 'kuery'
      }
    });
    setRuleParams('useKqlFilter', e.target.checked);
  };
  const kqlFilter = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_apm_rule_kql_filter.ApmRuleKqlFilter, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    onToggleKqlFilter: onToggleKqlFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    minimumWindowSize: {
      value: 5,
      unit: _public2.TIME_UNITS.MINUTE
    },
    chartPreview: chartPreview,
    defaultParams: params,
    fields: fields,
    groupAlertsBy: groupAlertsBy,
    kqlFilter: kqlFilter,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 5
    }
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = exports.default = TransactionDurationRuleType;