"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateMaintenanceWindowForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _convert_to_rrule = require("@kbn/response-ops-recurring-schedule-form/utils/convert_to_rrule");
var _recurring_schedule_form_fields = require("@kbn/response-ops-recurring-schedule-form/components/recurring_schedule_form_fields");
var _schema = require("./schema");
var i18n = _interopRequireWildcard(require("../translations"));
var _submit_button = require("./submit_button");
var _common = require("../../../../common");
var _use_create_maintenance_window = require("../../../hooks/use_create_maintenance_window");
var _use_update_maintenance_window = require("../../../hooks/use_update_maintenance_window");
var _use_get_rule_types = require("../../../hooks/use_get_rule_types");
var _kibana_react = require("../../../utils/kibana_react");
var _date_picker_range_field = require("./fields/date_picker_range_field");
var _use_archive_maintenance_window = require("../../../hooks/use_archive_maintenance_window");
var _maintenance_window_scoped_query_switch = require("./maintenance_window_scoped_query_switch");
var _maintenance_window_scoped_query = require("./maintenance_window_scoped_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/create_maintenance_windows_form.tsx",
  _UI_TIMEZONE_OPTIONS$;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const useDefaultTimezone = () => {
  const kibanaTz = (0, _kibana_react.useUiSetting)('dateFormat:tz');
  if (!kibanaTz || kibanaTz === 'Browser') {
    var _moment$tz$guess, _moment$tz;
    return {
      defaultTimezone: (_moment$tz$guess = (_moment$tz = _moment.default.tz) === null || _moment$tz === void 0 ? void 0 : _moment$tz.guess()) !== null && _moment$tz$guess !== void 0 ? _moment$tz$guess : 'UTC'
    };
  }
  return {
    defaultTimezone: kibanaTz
  };
};
const TIMEZONE_OPTIONS = (_UI_TIMEZONE_OPTIONS$ = _coreUiSettingsCommon.TIMEZONE_OPTIONS.map(timezoneOption => ({
  label: timezoneOption
}))) !== null && _UI_TIMEZONE_OPTIONS$ !== void 0 ? _UI_TIMEZONE_OPTIONS$ : [{
  label: 'UTC'
}];
const CreateMaintenanceWindowForm = exports.CreateMaintenanceWindowForm = /*#__PURE__*/_react.default.memo(props => {
  var _initialValue$scopedQ, _initialValue$scopedQ2;
  const {
    onCancel,
    onSuccess,
    initialValue,
    maintenanceWindowId,
    showMultipleSolutionsWarning = false
  } = props;
  const [defaultStartDateValue] = (0, _react.useState)((0, _moment.default)().toISOString());
  const [defaultEndDateValue] = (0, _react.useState)((0, _moment.default)().add(30, 'minutes').toISOString());
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    defaultTimezone
  } = useDefaultTimezone();
  const [isScopedQueryEnabled, setIsScopedQueryEnabled] = (0, _react.useState)(!!(initialValue !== null && initialValue !== void 0 && initialValue.scopedQuery));
  const [query, setQuery] = (0, _react.useState)((initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$scopedQ = initialValue.scopedQuery) === null || _initialValue$scopedQ === void 0 ? void 0 : _initialValue$scopedQ.kql) || '');
  const [filters, setFilters] = (0, _react.useState)((initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$scopedQ2 = initialValue.scopedQuery) === null || _initialValue$scopedQ2 === void 0 ? void 0 : _initialValue$scopedQ2.filters) || []);
  const [scopedQueryErrors, setScopedQueryErrors] = (0, _react.useState)([]);
  const isEditMode = initialValue !== undefined && maintenanceWindowId !== undefined;
  const onCreateOrUpdateError = (0, _react.useCallback)(error => {
    var _error$body;
    if (!((_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message)) {
      return;
    }
    if ((0, _common.isScopedQueryError)(error.body.message)) {
      setScopedQueryErrors([i18n.CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE]);
    }
  }, []);
  const {
    mutate: createMaintenanceWindow,
    isLoading: isCreateLoading
  } = (0, _use_create_maintenance_window.useCreateMaintenanceWindow)({
    onError: onCreateOrUpdateError
  });
  const {
    mutate: updateMaintenanceWindow,
    isLoading: isUpdateLoading
  } = (0, _use_update_maintenance_window.useUpdateMaintenanceWindow)({
    onError: onCreateOrUpdateError
  });
  const {
    mutate: archiveMaintenanceWindow
  } = (0, _use_archive_maintenance_window.useArchiveMaintenanceWindow)();
  const {
    data: ruleTypes,
    isLoading: isLoadingRuleTypes
  } = (0, _use_get_rule_types.useGetRuleTypes)();
  const transformQueryFilters = filtersToTransform => {
    return filtersToTransform.map(filter => {
      const {
        $state,
        meta,
        ...rest
      } = filter;
      return {
        $state,
        meta,
        query: filter !== null && filter !== void 0 && filter.query ? {
          ...filter.query
        } : {
          ...rest
        }
      };
    });
  };
  const scopedQueryPayload = (0, _react.useMemo)(() => {
    if (!isScopedQueryEnabled) {
      return null;
    }
    if (!query && !filters.length) {
      return null;
    }

    // Wrapping filters in query object here to avoid schema validation failure
    const transformedFilters = transformQueryFilters(filters);
    return {
      kql: query,
      filters: transformedFilters
    };
  }, [isScopedQueryEnabled, query, filters]);
  const submitMaintenanceWindow = (0, _react.useCallback)(async (formData, isValid) => {
    if (!isValid || scopedQueryErrors.length !== 0) {
      return;
    }
    if (isScopedQueryEnabled && !scopedQueryPayload) {
      setScopedQueryErrors([i18n.CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE]);
      return;
    }
    const startDate = (0, _moment.default)(formData.startDate);
    const endDate = (0, _moment.default)(formData.endDate);
    const maintenanceWindow = {
      title: formData.title,
      duration: endDate.diff(startDate),
      rRule: (0, _convert_to_rrule.convertToRRule)({
        startDate: startDate.toISOString(),
        timezone: formData.timezone ? formData.timezone[0] : defaultTimezone,
        recurringSchedule: formData.recurringSchedule
      }),
      scopedQuery: scopedQueryPayload !== null && scopedQueryPayload !== void 0 ? scopedQueryPayload : null,
      ...(showMultipleSolutionsWarning || scopedQueryPayload ? {
        categoryIds: null
      } : {})
    };
    if (isEditMode) {
      updateMaintenanceWindow({
        maintenanceWindowId,
        updateParams: maintenanceWindow
      }, {
        onSuccess
      });
    } else {
      createMaintenanceWindow(maintenanceWindow, {
        onSuccess
      });
    }
  }, [scopedQueryErrors.length, isScopedQueryEnabled, scopedQueryPayload, defaultTimezone, isEditMode, showMultipleSolutionsWarning, updateMaintenanceWindow, maintenanceWindowId, onSuccess, createMaintenanceWindow]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialValue,
    options: {
      stripEmptyFields: true
    },
    schema: _schema.schema,
    onSubmit: submitMaintenanceWindow
  });
  const [{
    recurring,
    timezone,
    startDate,
    endDate
  }, _, mounted] = (0, _hook_form_lib.useFormData)({
    form,
    watch: ['recurring', 'timezone', 'scopedQuery', 'startDate', 'endDate']
  });
  const isRecurring = recurring || false;
  const closeModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const showModal = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const ruleTypeIds = (0, _react.useMemo)(() => {
    if (!Array.isArray(ruleTypes) || !mounted) {
      return [];
    }
    return ruleTypes.map(ruleType => ruleType.id);
  }, [ruleTypes, mounted]);
  const onScopeQueryToggle = (0, _react.useCallback)(isEnabled => {
    setIsScopedQueryEnabled(isEnabled);
    if (scopedQueryErrors.length) {
      setScopedQueryErrors([]);
    }
  }, [setIsScopedQueryEnabled, scopedQueryErrors, setScopedQueryErrors]);
  const onQueryChange = (0, _react.useCallback)(newQuery => {
    if (scopedQueryErrors.length) {
      setScopedQueryErrors([]);
    }
    setQuery(newQuery);
  }, [scopedQueryErrors]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const modal = (0, _react.useMemo)(() => {
    let m;
    if (isModalVisible) {
      m = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": modalTitleId,
        title: i18n.ARCHIVE_TITLE,
        titleProps: {
          id: modalTitleId
        },
        onCancel: closeModal,
        onConfirm: () => {
          closeModal();
          archiveMaintenanceWindow({
            maintenanceWindowId: maintenanceWindowId,
            archive: true
          }, {
            onSuccess
          });
        },
        cancelButtonText: i18n.CANCEL,
        confirmButtonText: i18n.ARCHIVE_TITLE,
        defaultFocusedButton: "confirm",
        buttonColor: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 248,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 11
        }
      }, i18n.ARCHIVE_CALLOUT_SUBTITLE));
    }
    return m;
  }, [closeModal, archiveMaintenanceWindow, isModalVisible, maintenanceWindowId, onSuccess, modalTitleId]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    "data-test-subj": "createMaintenanceWindowForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "title",
    componentProps: {
      'data-test-subj': 'title-field',
      euiFieldProps: {
        'data-test-subj': 'createMaintenanceWindowFormNameInput',
        autoFocus: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 13
    }
  }, i18n.CREATE_FORM_TIMEFRAME_TITLE), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 15
    }
  }, i18n.CREATE_FORM_TIMEFRAME_DESCRIPTION)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseMultiFields, {
    fields: {
      startDate: {
        path: 'startDate',
        config: {
          label: i18n.CREATE_FORM_SCHEDULE,
          defaultValue: defaultStartDateValue,
          validations: []
        }
      },
      endDate: {
        path: 'endDate',
        config: {
          label: '',
          defaultValue: defaultEndDateValue,
          validations: []
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }, fields => /*#__PURE__*/_react.default.createElement(_date_picker_range_field.DatePickerRangeField, {
    fields: fields,
    timezone: timezone !== null && timezone !== void 0 ? timezone : [defaultTimezone],
    "data-test-subj": "date-field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "timezone",
    config: {
      type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
      validations: [],
      defaultValue: [defaultTimezone]
    },
    componentProps: {
      'data-test-subj': 'timezone-field',
      id: 'timezone',
      euiFieldProps: {
        fullWidth: true,
        options: TIMEZONE_OPTIONS,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        noSuggestions: false,
        placeholder: '',
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: 'timezone',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 354,
            columnNumber: 23
          }
        }, i18n.CREATE_FORM_TIMEZONE)
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "recurring",
    componentProps: {
      'data-test-subj': 'recurring-field',
      euiFieldProps: {
        'data-test-subj': 'createMaintenanceWindowRepeatSwitch'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  })), isRecurring && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_recurring_schedule_form_fields.RecurringScheduleFormFields, {
    startDate: startDate,
    endDate: endDate,
    timezone: timezone,
    initialRecurringSchedule: initialValue === null || initialValue === void 0 ? void 0 : initialValue.recurringSchedule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "scopedQuery",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 13
    }
  }, () => /*#__PURE__*/_react.default.createElement(_maintenance_window_scoped_query_switch.MaintenanceWindowScopedQuerySwitch, {
    checked: isScopedQueryEnabled,
    onEnabledChange: onScopeQueryToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "scopedQuery",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 13
    }
  }, () => /*#__PURE__*/_react.default.createElement(_maintenance_window_scoped_query.MaintenanceWindowScopedQuery, {
    ruleTypeIds: ruleTypeIds,
    query: query,
    filters: filters,
    isLoading: isLoadingRuleTypes,
    isEnabled: isScopedQueryEnabled,
    errors: scopedQueryErrors,
    onQueryChange: onQueryChange,
    onFiltersChange: setFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 17
    }
  })))), isScopedQueryEnabled && scopedQueryPayload || showMultipleSolutionsWarning ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "maintenanceWindowMultipleSolutionsRemovedWarning",
    title: i18n.SOLUTION_CONFIG_REMOVAL_WARNING_TITLE,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 15
    }
  }, i18n.SOLUTION_CONFIG_REMOVAL_WARNING_SUBTITLE))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: isEditMode ? 'spaceBetween' : 'flexEnd',
    gutterSize: "l",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 7
    }
  }, isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "danger",
    onClick: showModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 13
    }
  }, i18n.ARCHIVE), modal), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    size: "s",
    "data-test-subj": "cancelMaintenanceWindow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 15
    }
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_submit_button.SubmitButton, {
    isLoading: isCreateLoading || isUpdateLoading,
    editMode: isEditMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 15
    }
  }))))));
});
CreateMaintenanceWindowForm.displayName = 'CreateMaintenanceWindowForm';