"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageHeader = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _moment = _interopRequireDefault(require("moment"));
var _use_data_source = require("../../hooks/use_data_source");
var _storage = require("../../types/storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/page_header/page_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const dataViewTitleHeader = (0, _react.css)({
  minWidth: '300px'
});
const PageHeader = () => {
  const [, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: dataView.timeFieldName !== undefined,
    autoRefreshSelector: true
  });
  const updateTimeState = (0, _react2.useCallback)(update => {
    setGlobalState({
      time: {
        from: (0, _moment.default)(update.start.epoch).toISOString(),
        to: (0, _moment.default)(update.end.epoch).toISOString()
      }
    });
  }, [setGlobalState]);
  const hasValidTimeField = (0, _react2.useMemo)(() => dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView.timeFieldName]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react2.default.createElement("div", {
      css: dataViewTitleHeader,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 18
      }
    }, dataView.getName()),
    rightSideGroupProps: {
      gutterSize: 's',
      'data-test-subj': 'aiopsTimeRangeSelectorSection'
    },
    rightSideItems: [/*#__PURE__*/_react2.default.createElement(_mlDatePicker.DatePickerWrapper, {
      isAutoRefreshOnly: !hasValidTimeField,
      showRefresh: !hasValidTimeField,
      width: "full",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }), hasValidTimeField && /*#__PURE__*/_react2.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
      frozenDataPreference: frozenDataPreference,
      setFrozenDataPreference: setFrozenDataPreference,
      dataView: dataView,
      query: undefined,
      disabled: false,
      timefilter: timefilter,
      callback: updateTimeState,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    })].filter(Boolean),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  });
};
exports.PageHeader = PageHeader;