"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _item_filter_apply_button = require("./item_filter_apply_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765281832284290164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/item_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// This component is mostly inspired by EUI's Data Grid Column Selector
// https://github.com/elastic/eui/blob/main/packages/eui/src/components/datagrid/controls/column_selector.tsx
const ItemFilterPopover = ({
  dataTestSubj,
  disabled,
  disabledApplyButton,
  disabledApplyTooltipContent,
  helpText,
  itemSearchAriaLabel,
  initialSkippedItems = [],
  popoverButtonTitle,
  selectedItemLimit = 2,
  uniqueItemNames,
  onChange
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  // Inspired by https://github.com/elastic/eui/blob/v94.0.0/src/components/datagrid/controls/_data_grid_column_selector.scss
  const itemSelectPopover = (0, _react.useMemo)(() => (0, _react2.css)`
      ${(0, _eui.euiYScrollWithShadows)(euiThemeContext, {})}
      max-height: 400px;
    `, [euiThemeContext]);
  const [isTouched, setIsTouched] = (0, _react.useState)(false);
  const [itemSearchText, setItemSearchText] = (0, _react.useState)('');
  const [skippedItems, setSkippedItems] = (0, _react.useState)(initialSkippedItems);
  const setItemsFilter = (itemNames, checked) => {
    let updatedSkippedItems = [...skippedItems];
    if (!checked) {
      updatedSkippedItems.push(...itemNames);
    } else {
      updatedSkippedItems = skippedItems.filter(d => !itemNames.includes(d));
    }
    // Ensure there are no duplicates
    setSkippedItems([...new Set(updatedSkippedItems)]);
    setIsTouched(true);
  };
  const [isItemSelectionPopoverOpen, setIsItemSelectionPopoverOpen] = (0, _react.useState)(false);
  const onItemSelectionButtonClick = () => setIsItemSelectionPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsItemSelectionPopoverOpen(false);
  const filteredUniqueItemNames = (0, _react.useMemo)(() => {
    return uniqueItemNames.filter(d => d.toLowerCase().indexOf(itemSearchText.toLowerCase()) !== -1);
  }, [itemSearchText, uniqueItemNames]);

  // If the supplied list of unique field names changes, do a sanity check to only
  // keep field names in the list of skipped fields that still are in the list of unique fields.
  (0, _react.useEffect)(() => {
    setSkippedItems(previousSkippedItems => previousSkippedItems.filter(d => uniqueItemNames.includes(d)));
  }, [uniqueItemNames]);

  // If the supplied list of initial skipped items changes, only update if
  // the list hasn't been touched yet.
  (0, _react.useEffect)(() => {
    if (!isTouched) {
      setSkippedItems(initialSkippedItems);
    }
  }, [initialSkippedItems, isTouched]);
  const selectedItemCount = uniqueItemNames.length - skippedItems.length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    panelPaddingSize: "s",
    panelStyle: {
      minWidth: '20%'
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": dataTestSubj,
      onClick: onItemSelectionButtonClick,
      disabled: disabled,
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      iconSize: "s",
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, popoverButtonTitle),
    isOpen: isItemSelectionPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    style: {
      maxWidth: '400px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, helpText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    placeholder: _i18n.i18n.translate('xpack.aiops.analysis.fieldSelectorPlaceholder', {
      defaultMessage: 'Search'
    }),
    "aria-label": itemSearchAriaLabel,
    value: itemSearchText,
    onChange: e => setItemSearchText(e.currentTarget.value),
    "data-test-subj": "aiopsFieldSelectorSearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: itemSelectPopover,
    "data-test-subj": "aiopsFieldSelectorFieldNameList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, filteredUniqueItemNames.map(fieldName => /*#__PURE__*/_react.default.createElement("div", {
    key: fieldName,
    css: {
      padding: '4px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": `aiopsFieldSelectorFieldNameListItem${!skippedItems.includes(fieldName) ? ' checked' : ''}`,
    mini: true,
    label: fieldName,
    onChange: e => setItemsFilter([fieldName], e.target.checked),
    checked: !skippedItems.includes(fieldName),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    onClick: () => setItemsFilter(filteredUniqueItemNames, true),
    disabled: itemSearchText.length > 0 && filteredUniqueItemNames.length === 0,
    "data-test-subj": "aiopsFieldSelectorSelectAllFieldsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }, itemSearchText.length > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.fieldSelector.selectAllSearchedItems",
    defaultMessage: "Select filtered",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.fieldSelector.selectAllItems",
    defaultMessage: "Select all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: () => setItemsFilter(filteredUniqueItemNames, false),
    disabled: itemSearchText.length > 0 && filteredUniqueItemNames.length === 0,
    "data-test-subj": "aiopsFieldSelectorDeselectAllFieldsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, itemSearchText.length > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.fieldSelector.deselectAllSearchedItems",
    defaultMessage: "Deselect filtered",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.fieldSelector.deselectAllItems",
    defaultMessage: "Deselect all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_item_filter_apply_button.ItemFilterApplyButton, {
    onClick: () => {
      onChange(skippedItems);
      setItemSearchText('');
      setIsItemSelectionPopoverOpen(false);
      closePopover();
    },
    disabled: disabledApplyButton || selectedItemCount < selectedItemLimit || !isTouched,
    tooltipContent: selectedItemCount < selectedItemLimit ? disabledApplyTooltipContent : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  })))));
};
exports.ItemFilterPopover = ItemFilterPopover;