"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolvePostConstruct = resolvePostConstruct;
const common_1 = require("@inversifyjs/common");
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
function resolvePostConstruct(instance, binding, postConstructMethodName) {
    const postConstructResult = invokePostConstruct(instance, binding, postConstructMethodName);
    if ((0, common_1.isPromise)(postConstructResult)) {
        return postConstructResult.then(() => instance);
    }
    return instance;
}
function invokePostConstruct(instance, binding, postConstructMethodName) {
    if (postConstructMethodName === undefined) {
        return;
    }
    if (postConstructMethodName in instance) {
        if (typeof instance[postConstructMethodName] === 'function') {
            let postConstructResult;
            try {
                // eslint-disable-next-line @typescript-eslint/no-unsafe-call
                postConstructResult = instance[postConstructMethodName]();
            }
            catch (error) {
                throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.resolution, `Unexpected error found when calling "${postConstructMethodName.toString()}" @postConstruct decorated method on class "${binding.implementationType.name}"`, {
                    cause: error,
                });
            }
            if ((0, common_1.isPromise)(postConstructResult)) {
                return invokePostConstructAsync(binding, postConstructMethodName, postConstructResult);
            }
        }
        else {
            throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.resolution, `Expecting a "${postConstructMethodName.toString()}" method when resolving "${binding.implementationType.name}" class @postConstruct decorated method, a non function property was found instead.`);
        }
    }
    else {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.resolution, `Expecting a "${postConstructMethodName.toString()}" property when resolving "${binding.implementationType.name}" class @postConstruct decorated method, none found.`);
    }
}
async function invokePostConstructAsync(binding, postConstructMethodName, postConstructResult) {
    try {
        await postConstructResult;
    }
    catch (error) {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.resolution, `Unexpected error found when calling "${postConstructMethodName.toString()}" @postConstruct decorated method on class "${binding.implementationType.name}"`, {
            cause: error,
        });
    }
}
//# sourceMappingURL=resolvePostConstruct.js.map