"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorVisLight = void 0;
var _semantic_colors = require("./_semantic_colors");
var _primitive_colors = require("./_primitive_colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Maps allow for easier JSON usage
// Use map_merge(euiColorVisColors, $yourMap) to change individual colors after importing ths file
// The `behindText` variant is a direct copy of the hex output by the JS euiPaletteColorBlindBehindText() function
var euiPaletteColorBlind = {
  euiColorVis0: {
    graphic: _semantic_colors.SEMANTIC_COLORS.accentSecondary60
  },
  euiColorVis1: {
    graphic: _semantic_colors.SEMANTIC_COLORS.accentSecondary30
  },
  euiColorVis2: {
    graphic: _semantic_colors.SEMANTIC_COLORS.primary60
  },
  euiColorVis3: {
    graphic: _semantic_colors.SEMANTIC_COLORS.primary30
  },
  euiColorVis4: {
    graphic: _semantic_colors.SEMANTIC_COLORS.accent60
  },
  euiColorVis5: {
    graphic: _semantic_colors.SEMANTIC_COLORS.accent30
  },
  euiColorVis6: {
    graphic: _semantic_colors.SEMANTIC_COLORS.danger60
  },
  euiColorVis7: {
    graphic: _semantic_colors.SEMANTIC_COLORS.danger30
  },
  euiColorVis8: {
    graphic: _semantic_colors.SEMANTIC_COLORS.warning60
  },
  euiColorVis9: {
    graphic: _semantic_colors.SEMANTIC_COLORS.warning30
  }
};
var colorVisLight = exports.colorVisLight = {
  euiColorVis0: euiPaletteColorBlind.euiColorVis0.graphic,
  euiColorVis1: euiPaletteColorBlind.euiColorVis1.graphic,
  euiColorVis2: euiPaletteColorBlind.euiColorVis2.graphic,
  euiColorVis3: euiPaletteColorBlind.euiColorVis3.graphic,
  euiColorVis4: euiPaletteColorBlind.euiColorVis4.graphic,
  euiColorVis5: euiPaletteColorBlind.euiColorVis5.graphic,
  euiColorVis6: euiPaletteColorBlind.euiColorVis6.graphic,
  euiColorVis7: euiPaletteColorBlind.euiColorVis7.graphic,
  euiColorVis8: euiPaletteColorBlind.euiColorVis8.graphic,
  euiColorVis9: euiPaletteColorBlind.euiColorVis9.graphic,
  euiColorVisBehindText0: euiPaletteColorBlind.euiColorVis0.graphic,
  euiColorVisBehindText1: euiPaletteColorBlind.euiColorVis1.graphic,
  euiColorVisBehindText2: euiPaletteColorBlind.euiColorVis2.graphic,
  euiColorVisBehindText3: euiPaletteColorBlind.euiColorVis3.graphic,
  euiColorVisBehindText4: euiPaletteColorBlind.euiColorVis4.graphic,
  euiColorVisBehindText5: euiPaletteColorBlind.euiColorVis5.graphic,
  euiColorVisBehindText6: euiPaletteColorBlind.euiColorVis6.graphic,
  euiColorVisBehindText7: euiPaletteColorBlind.euiColorVis7.graphic,
  euiColorVisBehindText8: euiPaletteColorBlind.euiColorVis8.graphic,
  euiColorVisBehindText9: euiPaletteColorBlind.euiColorVis9.graphic,
  euiColorVisText0: _semantic_colors.SEMANTIC_COLORS.accentSecondary110,
  euiColorVisText1: _semantic_colors.SEMANTIC_COLORS.accentSecondary100,
  euiColorVisText2: _semantic_colors.SEMANTIC_COLORS.primary110,
  euiColorVisText3: _semantic_colors.SEMANTIC_COLORS.primary90,
  euiColorVisText4: _semantic_colors.SEMANTIC_COLORS.accent100,
  euiColorVisText5: _semantic_colors.SEMANTIC_COLORS.accent80,
  euiColorVisText6: _semantic_colors.SEMANTIC_COLORS.danger100,
  euiColorVisText7: _semantic_colors.SEMANTIC_COLORS.danger80,
  euiColorVisText8: _semantic_colors.SEMANTIC_COLORS.warning110,
  euiColorVisText9: _semantic_colors.SEMANTIC_COLORS.warning90,
  euiColorVisNeutral0: _semantic_colors.SEMANTIC_COLORS.neutral60,
  euiColorVisNeutral1: _semantic_colors.SEMANTIC_COLORS.neutral30,
  euiColorVisSuccess0: _semantic_colors.SEMANTIC_COLORS.success60,
  euiColorVisSuccess1: _semantic_colors.SEMANTIC_COLORS.success30,
  euiColorVisWarning0: _semantic_colors.SEMANTIC_COLORS.warning60,
  euiColorVisWarning1: _semantic_colors.SEMANTIC_COLORS.warning30,
  euiColorVisRisk0: _semantic_colors.SEMANTIC_COLORS.risk60,
  euiColorVisRisk1: _semantic_colors.SEMANTIC_COLORS.risk30,
  euiColorVisDanger0: _semantic_colors.SEMANTIC_COLORS.danger60,
  euiColorVisDanger1: _semantic_colors.SEMANTIC_COLORS.danger30,
  euiColorVisBase0: _primitive_colors.PRIMITIVE_COLORS.mutedGrey10,
  euiColorVisGrey0: _primitive_colors.PRIMITIVE_COLORS.blueGrey30,
  euiColorVisGrey1: _primitive_colors.PRIMITIVE_COLORS.blueGrey60,
  euiColorVisGrey2: _primitive_colors.PRIMITIVE_COLORS.blueGrey90,
  euiColorVisGrey3: _primitive_colors.PRIMITIVE_COLORS.blueGrey130,
  euiColorVisWarm0: _semantic_colors.SEMANTIC_COLORS.danger10,
  euiColorVisWarm1: _semantic_colors.SEMANTIC_COLORS.danger40,
  euiColorVisWarm2: _semantic_colors.SEMANTIC_COLORS.danger60,
  euiColorVisCool0: _semantic_colors.SEMANTIC_COLORS.primary10,
  euiColorVisCool1: _semantic_colors.SEMANTIC_COLORS.primary40,
  euiColorVisCool2: _semantic_colors.SEMANTIC_COLORS.primary60,
  euiColorVisComplementary0: _semantic_colors.SEMANTIC_COLORS.primary60,
  euiColorVisComplementary1: _semantic_colors.SEMANTIC_COLORS.warning60
};