/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Limiter;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class LimitOperator
implements Operator {
    private int pagesProcessed;
    private long rowsReceived;
    private long rowsEmitted;
    private Page lastInput;
    private final Limiter limiter;
    private boolean finished;

    public LimitOperator(Limiter limiter) {
        this.limiter = limiter;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.lastInput == null && this.limiter.remaining() > 0;
    }

    @Override
    public void addInput(Page page) {
        assert (this.lastInput == null) : "has pending input page";
        int acceptedRows = this.limiter.tryAccumulateHits(page.getPositionCount());
        if (acceptedRows == 0) {
            page.releaseBlocks();
            assert (this.isFinished());
        } else {
            this.lastInput = acceptedRows < page.getPositionCount() ? LimitOperator.truncatePage(page, acceptedRows) : page;
        }
        this.rowsReceived += (long)acceptedRows;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.lastInput == null && (this.finished || this.limiter.remaining() == 0);
    }

    @Override
    public Page getOutput() {
        if (this.lastInput == null) {
            return null;
        }
        Page result = this.lastInput;
        this.lastInput = null;
        ++this.pagesProcessed;
        this.rowsEmitted += (long)result.getPositionCount();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Page truncatePage(Page page, int upTo) {
        Page result;
        block7: {
            block6: {
                int[] filter = new int[upTo];
                for (int i = 0; i < upTo; ++i) {
                    filter[i] = i;
                }
                Releasable[] blocks = new Block[page.getBlockCount()];
                result = null;
                try {
                    for (int b = 0; b < blocks.length; ++b) {
                        blocks[b] = page.getBlock(b).filter(filter);
                    }
                    result = new Page((Block[])blocks);
                    if (result != null) break block6;
                }
                catch (Throwable throwable) {
                    if (result == null) {
                        Releasable[] releasableArray = new Releasable[2];
                        releasableArray[0] = page::releaseBlocks;
                        releasableArray[1] = Releasables.wrap((Releasable[])blocks);
                        Releasables.closeExpectNoException((Releasable[])releasableArray);
                    } else {
                        page.releaseBlocks();
                    }
                    throw throwable;
                }
                Releasable[] releasableArray = new Releasable[2];
                releasableArray[0] = page::releaseBlocks;
                releasableArray[1] = Releasables.wrap((Releasable[])blocks);
                Releasables.closeExpectNoException((Releasable[])releasableArray);
                break block7;
            }
            page.releaseBlocks();
        }
        return result;
    }

    @Override
    public Status status() {
        return new Status(this.limiter.limit(), this.limiter.remaining(), this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
    }

    @Override
    public void close() {
        if (this.lastInput != null) {
            this.lastInput.releaseBlocks();
        }
    }

    public String toString() {
        int limitRemaining = this.limiter.remaining();
        int limit = this.limiter.limit();
        return "LimitOperator[limit = " + limitRemaining + "/" + limit + "]";
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "limit", Status::new);
        private final int limit;
        private final int limitRemaining;
        private final int pagesProcessed;
        private final long rowsReceived;
        private final long rowsEmitted;

        protected Status(int limit, int limitRemaining, int pagesProcessed, long rowsReceived, long rowsEmitted) {
            this.limit = limit;
            this.limitRemaining = limitRemaining;
            this.pagesProcessed = pagesProcessed;
            this.rowsReceived = rowsReceived;
            this.rowsEmitted = rowsEmitted;
        }

        protected Status(StreamInput in) throws IOException {
            this.limit = in.readVInt();
            this.limitRemaining = in.readVInt();
            this.pagesProcessed = in.readVInt();
            this.rowsReceived = in.readVLong();
            this.rowsEmitted = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.limit);
            out.writeVInt(this.limitRemaining);
            out.writeVInt(this.pagesProcessed);
            out.writeVLong(this.rowsReceived);
            out.writeVLong(this.rowsEmitted);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int limit() {
            return this.limit;
        }

        public int limitRemaining() {
            return this.limitRemaining;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public long rowsReceived() {
            return this.rowsReceived;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("limit", this.limit);
            builder.field("limit_remaining", this.limitRemaining);
            builder.field("pages_processed", this.pagesProcessed);
            builder.field("rows_received", this.rowsReceived);
            builder.field("rows_emitted", this.rowsEmitted);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.limit == status.limit && this.limitRemaining == status.limitRemaining && this.pagesProcessed == status.pagesProcessed && this.rowsReceived == status.rowsReceived && this.rowsEmitted == status.rowsEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.limit, this.limitRemaining, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }

    public static final class Factory
    implements Operator.OperatorFactory {
        private final Limiter limiter;

        public Factory(int limit) {
            this.limiter = new Limiter(limit);
        }

        @Override
        public LimitOperator get(DriverContext driverContext) {
            return new LimitOperator(this.limiter);
        }

        @Override
        public String describe() {
            return "LimitOperator[limit = " + this.limiter.limit() + "]";
        }
    }
}

