/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.List;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class EsqlFlags {
    public static final Setting<Boolean> ESQL_STRING_LIKE_ON_INDEX = Setting.boolSetting((String)"esql.query.string_like_on_index", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> ESQL_ROUNDTO_PUSHDOWN_THRESHOLD = Setting.intSetting((String)"esql.query.roundto_pushdown_threshold", (int)127, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static List<Setting<?>> ALL_ESQL_FLAGS_SETTINGS = List.of(ESQL_STRING_LIKE_ON_INDEX, ESQL_ROUNDTO_PUSHDOWN_THRESHOLD);
    private final boolean stringLikeOnIndex;
    private final int roundToPushdownThreshold;

    public EsqlFlags(boolean stringLikeOnIndex) {
        this.stringLikeOnIndex = stringLikeOnIndex;
        this.roundToPushdownThreshold = (Integer)ESQL_ROUNDTO_PUSHDOWN_THRESHOLD.getDefault(Settings.EMPTY);
    }

    public EsqlFlags(int roundToPushdownThreshold) {
        this.stringLikeOnIndex = (Boolean)ESQL_STRING_LIKE_ON_INDEX.getDefault(Settings.EMPTY);
        this.roundToPushdownThreshold = roundToPushdownThreshold;
    }

    public EsqlFlags(boolean stringLikeOnIndex, int roundToPushdownThreshold) {
        this.stringLikeOnIndex = stringLikeOnIndex;
        this.roundToPushdownThreshold = roundToPushdownThreshold;
    }

    public EsqlFlags(ClusterSettings settings) {
        this.stringLikeOnIndex = (Boolean)settings.get(ESQL_STRING_LIKE_ON_INDEX);
        this.roundToPushdownThreshold = (Integer)settings.get(ESQL_ROUNDTO_PUSHDOWN_THRESHOLD);
    }

    public boolean stringLikeOnIndex() {
        return this.stringLikeOnIndex;
    }

    public int roundToPushdownThreshold() {
        return this.roundToPushdownThreshold;
    }
}

