/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.metrics;

public class ExponentiallyWeightedMovingRate {
    private final double lambda;
    private final long startTime;
    private double rate;
    private long lastTime;
    private boolean waitingForFirstIncrement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExponentiallyWeightedMovingRate(double lambda, long startTime) {
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda must be non-negative but was " + lambda);
        }
        ExponentiallyWeightedMovingRate exponentiallyWeightedMovingRate = this;
        synchronized (exponentiallyWeightedMovingRate) {
            this.lambda = lambda;
            this.rate = Double.NaN;
            this.startTime = startTime;
            this.lastTime = 0L;
            this.waitingForFirstIncrement = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRate(long time) {
        ExponentiallyWeightedMovingRate exponentiallyWeightedMovingRate = this;
        synchronized (exponentiallyWeightedMovingRate) {
            if (this.waitingForFirstIncrement) {
                return 0.0;
            }
            if (time <= this.lastTime) {
                return this.rate;
            }
            return this.expHelper(this.lastTime - this.startTime) * Math.exp(-1.0 * this.lambda * (double)(time - this.lastTime)) * this.rate / this.expHelper(time - this.startTime);
        }
    }

    public double calculateRateSince(long currentTime, double currentRate, long oldTime, double oldRate) {
        if (oldTime < this.startTime) {
            oldTime = this.startTime;
        }
        if (currentTime <= oldTime) {
            return 0.0;
        }
        return (this.expHelper(currentTime - this.startTime) * currentRate - this.expHelper(oldTime - this.startTime) * Math.exp(-1.0 * this.lambda * (double)(currentTime - oldTime)) * oldRate) / this.expHelper(currentTime - oldTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncrement(double increment, long time) {
        ExponentiallyWeightedMovingRate exponentiallyWeightedMovingRate = this;
        synchronized (exponentiallyWeightedMovingRate) {
            if (this.waitingForFirstIncrement) {
                if (time <= this.startTime) {
                    time = this.startTime + 1L;
                }
                this.rate = increment / this.expHelper(time - this.startTime);
                this.waitingForFirstIncrement = false;
            } else {
                if (time < this.lastTime) {
                    time = this.lastTime;
                }
                this.rate += (increment - this.expHelper(time - this.lastTime) * this.rate) / this.expHelper(time - this.startTime);
            }
            this.lastTime = time;
        }
    }

    private double expHelper(double time) {
        assert (time >= 0.0);
        double lambdaTime = this.lambda * time;
        if (lambdaTime >= 0.01) {
            return (1.0 - Math.exp(-1.0 * lambdaTime)) / this.lambda;
        }
        if (lambdaTime >= 1.0E-10) {
            return -1.0 * Math.expm1(-1.0 * lambdaTime) / this.lambda;
        }
        return time * (1.0 - 0.5 * lambdaTime);
    }

    public double getHalfLife() {
        return Math.log(2.0) / this.lambda;
    }
}

