/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import java.math.BigDecimal;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Mutate1D;

public final class AXPY
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] y, int basey, BigDecimal a, BigDecimal[] x, int basex, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            y[basey + i] = BigMath.ADD.invoke(y[basey + i], BigMath.MULTIPLY.invoke(a, x[basex + i]));
        }
    }

    public static void invoke(double[] y, int basey, double a, double[] x, int basex, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            int n = basey + i;
            y[n] = y[n] + a * x[basex + i];
        }
    }

    public static void invoke(float[] y, int basey, float a, float[] x, int basex, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            int n = basey + i;
            y[n] = y[n] + a * x[basex + i];
        }
    }

    public static void invoke(Mutate1D.Modifiable<?> y, double a, BigDecimal[] x) {
        BigDecimal tmpA = new BigDecimal(a);
        for (int i = 0; i < x.length; ++i) {
            y.add((long)i, x[i].multiply(tmpA));
        }
    }

    public static void invoke(Mutate1D.Modifiable<?> y, double a, double[] x) {
        for (int i = 0; i < x.length; ++i) {
            y.add((long)i, a * x[i]);
        }
    }

    public static void invoke(Mutate1D.Modifiable<?> y, double a, float[] x) {
        for (int i = 0; i < x.length; ++i) {
            y.add((long)i, a * (double)x[i]);
        }
    }

    public static <N extends Scalar<N>> void invoke(Mutate1D.Modifiable<?> y, double a, N[] x) {
        for (int i = 0; i < x.length; ++i) {
            y.add((long)i, (Comparable)((Scalar)x[i].multiply(a)).get());
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] y, int basey, N a, N[] x, int basex, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            y[basey + i] = (Scalar)y[basey + i].add((Scalar)a.multiply(x[basex + i])).get();
        }
    }
}

