/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.validation;

import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.validation.ServiceIntegrationValidator;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalService;
import org.elasticsearch.xpack.inference.services.validation.ChatCompletionModelValidator;
import org.elasticsearch.xpack.inference.services.validation.ElasticsearchInternalServiceModelValidator;
import org.elasticsearch.xpack.inference.services.validation.ModelValidator;
import org.elasticsearch.xpack.inference.services.validation.SimpleChatCompletionServiceIntegrationValidator;
import org.elasticsearch.xpack.inference.services.validation.SimpleModelValidator;
import org.elasticsearch.xpack.inference.services.validation.SimpleServiceIntegrationValidator;
import org.elasticsearch.xpack.inference.services.validation.TextEmbeddingModelValidator;

public class ModelValidatorBuilder {
    public static ModelValidator buildModelValidator(TaskType taskType, InferenceService service) {
        if (service instanceof ElasticsearchInternalService) {
            return new ElasticsearchInternalServiceModelValidator(new SimpleServiceIntegrationValidator());
        }
        return ModelValidatorBuilder.buildModelValidatorForTaskType(taskType, service);
    }

    private static ModelValidator buildModelValidatorForTaskType(TaskType taskType, InferenceService service) {
        if (taskType == null) {
            throw new IllegalArgumentException("Task type can't be null");
        }
        ServiceIntegrationValidator validatorFromService = null;
        if (service != null) {
            validatorFromService = service.getServiceIntegrationValidator(taskType);
        }
        switch (taskType) {
            case TEXT_EMBEDDING: {
                return new TextEmbeddingModelValidator(Objects.requireNonNullElse(validatorFromService, new SimpleServiceIntegrationValidator()));
            }
            case COMPLETION: {
                return new ChatCompletionModelValidator(Objects.requireNonNullElse(validatorFromService, new SimpleServiceIntegrationValidator()));
            }
            case CHAT_COMPLETION: {
                return new ChatCompletionModelValidator(Objects.requireNonNullElse(validatorFromService, new SimpleChatCompletionServiceIntegrationValidator()));
            }
            case SPARSE_EMBEDDING: 
            case RERANK: 
            case ANY: {
                return new SimpleModelValidator(Objects.requireNonNullElse(validatorFromService, new SimpleServiceIntegrationValidator()));
            }
        }
        throw new IllegalArgumentException(Strings.format((String)"Can't validate inference model for task type %s", (Object[])new Object[]{taskType}));
    }
}

